//
//  OTimeField.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/9/20.
//  Copyright © 2020 Amine. All rights reserved.
//

import UIKit
import SkyFloatingLabelTextField


class OTimeField : OField{
    
    override func getKey() -> String {
        return field!.label
    }
    
    override func getValue() -> String {
        return (labelView?.text!)!.trimmingCharacters(in: .whitespacesAndNewlines)
    }
    
    override func getField() -> CField? {
        return field
    }
    
    var viewController: UIViewController?
    
    static func newInstance() -> OTimeField{
        return OTimeField()
    }
   
    var labelView: SkyFloatingLabelTextField? = nil
    
    var field: CField?
    
    func setup(field: CField) ->  OTimeField{
        
        self.field = field
        
        let textField = SkyFloatingLabelTextField(frame: CGRect(x: 150, y: 10, width: 100, height: 50))
        
        
        if field.required == 1{
            textField.placeholder = field.label+" (*)"
            textField.title = field.label+" (*)"
        }else{
            textField.placeholder = field.label
            textField.title = field.label
        }
        
        
        addSubview(textField)
        addConstraintsWithFormat(format: "H:|[v0]|", views: textField)
        addConstraintsWithFormat(format: "V:|[v0]|", views: textField)
        
        labelView = textField;
        
        
        textField.textColor = UIColor.black
        textField.lineColor = UIColor.gray
        textField.selectedTitleColor = UIColor.black
        textField.selectedLineColor = Colors.primaryColor
        textField.selectedLineHeight = 1.5
        textField.lineHeight = 0.5
        textField.titleColor = Colors.primaryColor
        textField.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 14)
        textField.titleFont = UIFont(name: AppConfig.Design.Fonts.regular, size: 14)!
        textField.addTarget(self, action: #selector(textFieldDidChange(_:)), for: .editingChanged)
        
        // textField.inputAccessoryView = setupDoneButtonOnKeyboard()
        
        
        
        setupDateBeginPicker()
        
        
        return self
        
    }
    
    // This will notify us when something has changed on the textfield
    @objc func textFieldDidChange(_ textfield: UITextField) {
        if let text = textfield.text {
            if let floatingLabelTextField = textfield as? SkyFloatingLabelTextField {
                floatingLabelTextField.errorMessage = ""
            }
        }
    }
    
    
    
    func setupDoneButtonOnKeyboard() -> UIToolbar
    {
        let doneToolbar: UIToolbar = UIToolbar(frame: CGRect(x:0, y:0, width:320, height:50))
        doneToolbar.barStyle = UIBarStyle.default

     let flexSpace = UIBarButtonItem(barButtonSystemItem: UIBarButtonItem.SystemItem.flexibleSpace, target: nil, action: nil)
     let done: UIBarButtonItem = UIBarButtonItem(title: "Done".localized, style: UIBarButtonItem.Style.done, target: self, action: #selector(doneButtonAction))

        let items = NSMutableArray()
        items.add(flexSpace)
        items.add(done)

        doneToolbar.items = items as? [UIBarButtonItem]
        doneToolbar.sizeToFit()
        
        return doneToolbar
       
    }
    
    @objc func doneButtonAction()
    {
        labelView?.resignFirstResponder()
    }
    
    
    
    
    
    let datePicker = UIDatePicker()
       let timePicker = UIDatePicker()
       
       func setupDateBeginPicker(){
           //Formate Date
        datePicker.datePickerMode = .time
           
           //ToolBar
           let toolbar = UIToolbar();
           toolbar.sizeToFit()
           
           //done button & cancel button
           let doneButton = UIBarButtonItem(title: "Done".localized, style: UIBarButtonItem.Style.bordered, target: self, action: #selector(doneDateBeginPicker))
           let spaceButton = UIBarButtonItem(barButtonSystemItem: UIBarButtonItem.SystemItem.flexibleSpace, target: nil, action: nil)
           let cancelButton = UIBarButtonItem(title: "Cancel".localized, style: UIBarButtonItem.Style.bordered, target: self, action: #selector(cancelDateBeginPicker))
           toolbar.setItems([cancelButton,spaceButton, doneButton],animated: false)
           
           
           // add toolbar to textField
        self.labelView!.inputAccessoryView = toolbar
           // add datepicker to textField
        self.labelView!.inputView = datePicker
                         
           
           if #available(iOS 13.0, *){
                 
           }else{
               
           }
          
       }
    
    
    
     @objc func doneDateBeginPicker(){
         
         let formatter = DateFormatter()
         formatter.dateFormat = "HH:mm:ss"
        self.labelView!.text = formatter.string(from: datePicker.date)
         self.endEditing(true)
         
     }
     
     
     @objc func cancelDateBeginPicker(){
         self.endEditing(true)
     }
     
    
}


