
import UIKit

protocol V_OptionDelegate {
    func onClicked(option: O_Option)
}

class V_Option: UIView {
    
    var o: O_Option?
    var delegate: V_OptionDelegate? = nil
    
    enum Types {
        case Radio
        case Checkbox
    }
    
  
    static func newInstance(option: O_Option) ->  V_Option{
        
        let view:V_Option = UINib(nibName: "V_Option", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! V_Option
        
        view.heightAnchor.constraint(equalToConstant: 50).isActive = true
        view.setup(option: option)
        return view
    }
    
    @IBOutlet weak var check_icon: UIImageView!
    @IBOutlet weak var option_title: UILabel!
  
    
    func setup(option: O_Option){
        
        self.o = option
      
       // self.text_edit_field.isHidden = true
        self.option_title.initDefaultFont(size: 16)
        self.option_title.textColor = .darkGray
      
        //set as unchecked
        uncheck_radio()
        
        
        self.option_title.text = option.label
      
        //register gesture reconizer for gallery
        let gestureRecognizer1 = UITapGestureRecognizer(target: self, action: #selector(didTapOnItem))
       
        self.addGestureRecognizer(gestureRecognizer1)
        self.isUserInteractionEnabled = true
        
        
        
        
    }
    
    var is_checked = false
    
    @objc func didTapOnItem()  {
        
        if let del = delegate, let opt = self.o{
            del.onClicked(option: opt)
        }
        
    }
    
    func check_radio()  {
        
        let check_icon = UIImage(named: "check")
        self.check_icon.image = check_icon
        
        is_checked = true
       
        
    }
    
    func uncheck_radio()  {
        
        let uncheck_icon = UIImage(named: "uncheck")
        self.check_icon.image = uncheck_icon
    
        is_checked = false
       
    }
    
    
    func check_checknox()  {
        
        let check_icon = UIImage(named: "check-square")
        self.check_icon.image = check_icon
        
        is_checked = true
        
    }
    
    func uncheck_checkbox()  {
        
        let uncheck_icon = UIImage(named: "uncheck-square")
        self.check_icon.image = uncheck_icon
        
        is_checked = false
    
    }
    
    
    
}


struct O_Group {
    
    var group_label: String
    var group_type: String

}

struct O_Option {

    var label: String
    var value: String
    var custom_value: Bool
    
}

