//
//  TitleView.swift
//  DealifyDeliveryBoy
//
//  Created by DT Team  on 2/8/21.
//  Copyright © 2021 Amine. All rights reserved.
//

import UIKit


class TextLine: UIView{
    
    
    static func newInstance() ->  TextLine{
        
        return UINib(nibName: "TextLine", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! TextLine
    
    }
    
    @IBOutlet weak var line: UIView!
    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var value: UILabel!
    
    func setup()  {
        
        self.label.initDefaultFont()
        self.label.textColor =  UIColor.lightGray
        self.line.backgroundColor = UIColor.lightGray.withAlphaComponent(0.6)
        self.value.initBolodFont(size: 14)
        self.value.textColor =  UIColor.darkGray
        
        
       
    }
    
    func header(title: String)  -> TextLine{
        
        self.setup()

        self.label.textColor =  UIColor.darkGray
        self.label.initBolodFont(size: 16)
        self.label.text = title
        
        
        self.value.isHidden = true
        self.line.isHidden = false
       
        return self
    }
       

}



extension UIButton{
    
    static func new(text: String) -> UIButton {
        
        
        let btn = UIButton()
        btn.backgroundColor = Colors.primaryColor
        btn.initDefaultFont(size: 14)
        btn.setTitle(text, for: .normal)
    
       
        return btn
    }
    
    
}



extension UIStackView{
    
    static func col2_labelView(text: String, value: String) -> UIStackView {
        
        let item1 = UILabel.new(label_text: text)
        let item2 = UILabel.new(label_text: value)
        item2.textAlignment = .right
                    
        let stackV = UIStackView()
        stackV.axis = .horizontal
        stackV.distribution = .fillProportionally
    
        stackV.addArrangedSubview(item1)
        stackV.addArrangedSubview(item2)
        
        return stackV
        
   }
    
    
    static func col2_labelView(text: String, value: String, color: UIColor) -> UIStackView {
        
        let item1 = UILabel.new(label_text: text)
        let item2 = UILabel.new(label_text: value)
        item2.textColor = color
        item2.textAlignment = .right
        
                    
        let stackV = UIStackView()
        stackV.axis = .horizontal
        stackV.distribution = .fillProportionally
    
        stackV.addArrangedSubview(item1)
        stackV.addArrangedSubview(item2)
        
        return stackV
        
   }
    
}


class UserContact2Cols : UIStackView{
    
    var btn1: UIButton?
    var btn2: UIButton?

    func setup(b1: String, b2: String, compilationB1: @escaping (UIButton?) -> (), compilationB2: @escaping (UIButton?) -> ()) -> UserContact2Cols {
        
        self.distribution = .fillEqually
        self.axis = .horizontal
        self.spacing = 5
        
        
        self.btn1 = UIButton.new(text: b1)
        self.btn2 = UIButton.new(text: b2)
        
      
        self.addArrangedSubview(btn1!)
        self.addArrangedSubview(btn2!)
        
        
        let gestureRecognizerB1 = BindableGestureRecognizer {
                compilationB1( self.btn1!)
        }
        self.btn1!.addGestureRecognizer(gestureRecognizerB1)

        
        let gestureRecognizerB2 = BindableGestureRecognizer {
                compilationB2( self.btn2!)
        }
        
        self.btn2!.addGestureRecognizer(gestureRecognizerB2)

        return self
        
   }
    
   
    
    
}



final class BindableGestureRecognizer: UITapGestureRecognizer {
    private var action: () -> Void

    init(action: @escaping () -> Void) {
        self.action = action
        super.init(target: nil, action: nil)
        self.addTarget(self, action: #selector(execute))
    }

    @objc private func execute() {
        action()
    }
}
