//
//  ProductLine.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/10/20.
//  Copyright © 2020 Amine. All rights reserved.
//

import Foundation
import UIKit


protocol ProductLineDelegate:class  {
    func onProductPressed(id: Int,module:String)
}


class ProductLine : UIView{

    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    @IBOutlet weak var left_view_container: UIView!
    @IBOutlet weak var product_value: UILabel!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var name: UILabel!
    @IBOutlet weak var desc: UILabel!
    
    var delegate: ProductLineDelegate?
    @objc func clicked(_ sender: Any) {
        if let o = self.product, let del = delegate{
            del.onProductPressed(id: o.id,module: "offer")
        }
    }
    
    var product: ProductLineItem?
    
    func setup(product: ProductLineItem) ->  ProductLine{
        
        self.product = product
        
        left_view_container.isUserInteractionEnabled = true
               
        let gestureRecognizer1 = UITapGestureRecognizer(target: self, action: #selector(clicked))
        left_view_container.addGestureRecognizer(gestureRecognizer1)
        
        

        name.initBolodFont()
        desc.initDefaultFont()
        product_value.initBolodFont()
        
        name.text = product.name
        desc.text = "\("Qty".localized): \(product.qty)"
        
        
        product_value.text =  product.amount_s
       
        
        if product.image_url != "" {
            
            let url = URL(string: product.image_url)
            self.image.kf.indicatorType = .activity
            self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            
        }else{
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        
        return self
    }
    
    
    static func newInstance() ->  ProductLine{
        let view:ProductLine = UINib(nibName: "ProductLine", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! ProductLine
        return view
    }
    
    
}


struct ProductLineItem {
    
    var id: Int
    var module: String
    var image_url: String
    var name: String
    var desc: String
    var amount_s: String
    var amount_v: Double
    var qty: Double
    
}
