//
//  File.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit

protocol PaymentMethodDelegate:class  {
    func paymentMethodressed(method: OrderPayment,view: PaymentMethod)
}

class PaymentMethod : UIView{

    @IBOutlet weak var image_checked: UIImageView!
    @IBOutlet weak var shadow_: UIView!
    @IBOutlet weak var card_container: UIView!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var payment_description: UILabel!
    
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    static func newInstance() ->  PaymentMethod{
          let view:PaymentMethod = UINib(nibName: "PaymentMethod", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! PaymentMethod
          return view
      }
    
    
    var isActive = false
    var _method: OrderPayment?
    
    var delegate: PaymentMethodDelegate?
      @objc func clicked(_ sender: Any) {
          if let m = _method, let del = delegate{
            del.paymentMethodressed(method: m, view: self)
          }
    }
    
    func setup(method: OrderPayment) -> PaymentMethod{
        
        _method = method
        
        
        label.initBolodFont()
        payment_description.initItalicFont()
        
        image_checked.isHidden = true
        
         card_container.isUserInteractionEnabled = true
        let gestureRecognizer1 = UITapGestureRecognizer(target: self, action: #selector(clicked))
        card_container.addGestureRecognizer(gestureRecognizer1)
               
               
        
        // radius & shadowing style
        shadow_.backgroundColor = UIColor.gray.withAlphaComponent(0.3)
        shadow_.roundedCorners(radius: 20)
        card_container.roundedCorners(radius: 20)
             
        
        
        if method.image != "" {
                   
            let url = URL(string: method.image)
            self.image.kf.indicatorType = .activity
            self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
                   
        }else{
            if let img = UIImage(named: "cash") {
                self.image.image = img
            }
        }
        
      
        label.text = method.method
        payment_description.text = method.payment_desctiption
        
       
        return self
    }

}
