//
//  File.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit

protocol OCustomButtonDelegate:class  {
    func onOCB_Pressed(ocid: Int)
}


class OCustomButtonView : UIView{

    var id = 0
    var delegate: OCustomButtonDelegate?
    
    @IBOutlet weak var oc_button: UIButton!
    @IBAction func oc_press_action(_ sender: Any) {
        
        if let del = delegate{
            del.onOCB_Pressed(ocid: id)
        }
    }
    
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    static func newInstance() ->  OCustomButtonView{
          let view:OCustomButtonView = UINib(nibName: "OCustomButtonView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! OCustomButtonView
          //view.frame = CGRect(x: 0, y: 0, width: view.frame.width, height: view.frame.height + 20.0)
          return view
      }
    
    func setup(title: String,color: UIColor) -> OCustomButtonView{
        
        oc_button.backgroundColor = color
        oc_button.setTitle(title, for: .normal)
        oc_button.setTitleColor(.white, for: .normal)
        oc_button.initItalicFont()
        
        return self
    }
    
   

}
