//
//  File.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit


protocol ContactViewDelegate {
    func onLeftPressed(id: Int)
    func onRightPressed(id: Int)
    func onCancel()
}

class ContactsView : UIView{
    
    
    var delegate: ContactViewDelegate? = nil
    
    var id = 0
    var qty = 1.0
    
    @IBOutlet weak var left_contact_btn: UIButton!
    @IBOutlet weak var right_contact_btn: UIButton!
   
    
    @IBAction func client_contact_action(_ sender: Any) {
        
        if let del = delegate{
            del.onLeftPressed(id: id)
        }
        
    }
    
    @IBAction func owner_contact_action(_ sender: Any) {
    
        if let del = delegate{
            del.onRightPressed(id: id)
        }
        
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
  
    
    static func newInstance() ->  ContactsView{
        
          let view:ContactsView = UINib(nibName: "ContactsView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! ContactsView
        
        
         view.initViews()
      
        
          return view
      }
    
    
  
    
    func initViews()  {
      
        self.left_contact_btn.setCustomButtonControlStyle(active: true)
        self.right_contact_btn.setCustomButtonControlStyle(active: false)
            
        
        self.left_contact_btn.initBoldFont()
        self.right_contact_btn.initBoldFont()
    }
   

}
