//
//  OptionsLauncher.swift
//  NearbyStores
//
//  Created by DT Team on 6/29/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import AssistantKit


protocol ContactPopupDelegate {
    func onLeftPressed(id: Int)
    func onRightPressed(id: Int)
}


class ContactPopupView: NSObject, ContactViewDelegate{
    
    
    func onCancel() {
        
    }

    
    func onLeftPressed(id: Int) {
     
        
        if let del = delegate{
            del.onLeftPressed(id: id)
        }
        
        handleDismiss()
    }
    
    
    func onRightPressed(id: Int) {
        
        if let del = delegate{
            del.onRightPressed(id: id)
        }
        
        handleDismiss()
    }
    
    
    
    var delegate: ContactPopupDelegate? = nil
    let blackView = UIView()

    var mView: ContactsView? = nil
    
    
    func show(id: Int) {
        //show menu
        
        
        
        if let window = UIApplication.shared.keyWindow {
            
            blackView.backgroundColor = UIColor(white: 0, alpha: 0.5)
            blackView.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(handleDismiss)))
            
            window.addSubview(blackView)
            
            
            let height: CGFloat = 50+50
            let y = window.frame.height - height
        
            mView = ContactsView.newInstance()
            mView?.id = id
            mView?.initViews()
            
            mView?.left_contact_btn.setCustomButtonControlStyle(active: true)
            mView?.right_contact_btn.setCustomButtonControlStyle(active: false)
            
            
            mView?.left_contact_btn.setTitle("Call client".localized, for: .normal)
            mView?.right_contact_btn.setTitle("Call owner".localized, for: .normal)
            
            
            mView?.delegate = self

            window.addSubview(mView!)
            
            mView?.roundCorners(corners: [.topRight, .topLeft], radius: 20)
            
        
            mView!.frame = CGRect(x: 0, y: window.frame.height, width: window.frame.width, height: height)
            
            blackView.frame = window.frame
            blackView.alpha = 0
            
            UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
                
                self.blackView.alpha = 1
                self.mView!.frame = CGRect(x: 0, y: y, width: self.mView!.frame.width, height: self.mView!.frame.height)
                
            }, completion: nil)
        }
    }
    
    @objc func handleDismiss() {
        
        UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
            
            self.blackView.alpha = 0
            
            if let window = UIApplication.shared.keyWindow {
                self.mView!.frame = CGRect(x: 0, y: window.frame.height, width: self.mView!.frame.width, height: self.mView!.frame.height)
            }
            
        }) { (completed: Bool) in
            if let delegate = self.delegate {
               
            }
        }
    }
    
    
    override init() {
        super.init()
        
        
    }
    
  
    
    func createIcon(_ icon: FontType) -> UIImage {
        return UIImage.init(icon: icon, size: CGSize(width: 25, height: 25), textColor: UIColor.darkGray)
    }
    
    
    
}

