//
//  Order.swift
//  NSApplication1.8
//
//  Created by DT Team  on 5/11/20.
//  Copyright © 2020 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class Order: Object{
    
    @objc dynamic var id: Int = 0
    @objc dynamic var user_id: Int = 0
    @objc dynamic var status: String = ""
    @objc dynamic var created_at: String = ""
    @objc dynamic var payment_status: String = ""
    @objc dynamic var invoice: Int = 0
    @objc dynamic var amount: Double = 0
    @objc dynamic var CFData: String = ""
    @objc dynamic var delivery_status: Int = 0
    @objc dynamic var delivery_commission: Double = 0
    @objc dynamic var extras: String = ""
    var timeline: List<TLPoint> = List<TLPoint>()
    
    
    var items: List<OrderItem> = List<OrderItem>()
   
    
    @objc dynamic var store_id: Int = 0
    @objc dynamic var delivery_id: Int = 0
   
    
    override static func primaryKey() -> String? {
        return "id"
    }
    
    var is_open = false

}

class TLPoint : Object{
    
    @objc dynamic var id: String = ""
    @objc dynamic var date: String = ""
    @objc dynamic var status: String = ""
    @objc dynamic var message: String = ""
    @objc dynamic var order_id: Int = 0
    @objc dynamic var managed_by: String = ""
    
    override static func primaryKey() -> String? {
        return "id"
    }
}



extension Order{
    
    static func removeAll() {
        
        let realm = try! Realm()
        
        let result: Results<Order> = realm.objects(Order.self)
        
        realm.beginWrite()
        realm.delete(result)
        try! realm.commitWrite()
    }
}


class OrderItem: Object{
    
    @objc dynamic var id: Int = 0
    @objc dynamic var oi_id: String = ""
    @objc dynamic var module: String = ""
    @objc dynamic var image: String = ""
    @objc dynamic var name: String = ""
    @objc dynamic var amount: Double = 0
    @objc dynamic var Qty: Double = 0
    @objc dynamic var currency: Currency?
 
    override static func primaryKey() -> String? {
        return "oi_id"
    }
    

}


class OrderPayment: Object{
    
    @objc dynamic var id: String = ""
    @objc dynamic var method: String = ""
    @objc dynamic var image: String = ""
    @objc dynamic var payment_desctiption: String = ""
    @objc dynamic var tax: OrderPaymentTax?
 
    override static func primaryKey() -> String? {
        return "id"
    }
    
    
    
    
       static func removeAll() {
           
           let realm = try! Realm()
           
           let result: Results<OrderPayment> = realm.objects(OrderPayment.self)
           
           realm.beginWrite()
           realm.delete(result)
           try! realm.commitWrite()
       }
       

}

class OrderPaymentTax: Object{
    
    @objc dynamic var id: Int = 0
    @objc dynamic var value: Double = 0.0
    @objc dynamic var name: String = ""
 
    override static func primaryKey() -> String? {
        return "id"
    }
    

}





extension Order{
    
    func save() {
        if self.id > 0 {
            
            let order = self
            
            let realm = try! Realm()
            realm.beginWrite()
            realm.add(order,update: .all)
            try! realm.commitWrite()
            
        }
    }
    
    static func findById(id: Int) -> Order? {
        
        let realm = try! Realm()
        
        if let order = realm.objects(Order.self).filter("id == \(id)").first {
            return order
        }
        
        return nil
    }
}


extension Array where Element:Order {
    
    func saveAll(){
        
        let orders: [Order] = self
        
        if orders.count > 0 {
            
            let realm = try! Realm()
            
            realm.beginWrite()
            realm.add(orders,update: .all)
            try! realm.commitWrite()
            
        }
        
    }
    
    
    func getindex(order_id: Int) -> Int? {
        
        var orders: [Order] = self
        
        
        //resfresh item to the top
        let size = orders.count - 1
        
        if size >= 0 {
            
            for index in 0...size {
                
                if orders[index].id == order_id{
                    return index
                }
                
            }
            
        }
        
        
        return nil
        
    }
        
}




extension Array where Element:OrderPayment {

    func saveAll(){
       
        let objects: [OrderPayment] = self
        
        if objects.count > 0 {
            
            let realm = try! Realm()
            
            realm.beginWrite()
            realm.add(objects,update: .all)
            try! realm.commitWrite()
            
        }
        
    }
}

