//
//  AboutViewController.swift
//  NearbyStores
//
//  Created by DT Team on 7/17/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import Atributika
import AssistantKit
import SwiftyJSON
import MapKit
import RealmSwift
import SwiftEventBus




class DeliveryProfileController: MyUIViewController, EmptyLayoutDelegate, ErrorLayoutDelegate{
    


    @IBOutlet weak var navigationBar: UINavigationBar!
    @IBOutlet weak var navigationBarItem: UINavigationItem!
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet weak var stackview: UIStackView!

    
    let topBarTitle: EdgeLabel = {
        
        let titleLabel = EdgeLabel()
        
        titleLabel.text = ""
        titleLabel.textColor = UIColor.white
        titleLabel.font = UIFont.systemFont(ofSize: 20)
        
        return titleLabel
        
    }()
    
    func setupNavBarTitles() {
        
        
        let rect = CGRect(x: 0, y: 0, width: view.frame.width - 32, height: view.frame.height)
        topBarTitle.frame = rect
        topBarTitle.textColor = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
        topBarTitle.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 17)
        topBarTitle.leftTextInset = 5
        
        
        topBarTitle.text = "Revenue & Payment"
        
        navigationBarItem.titleView = topBarTitle
        
    }
    
    
    
    func setupNavBarButtons() {
        
        let color = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
        
        //arrow back icon
        var arrowImage: UIImage? = nil
        if Utils.isRTL(){
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowForward), size: CGSize(width: 30, height: 30), textColor: color)
        }else{
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowBack), size: CGSize(width: 30, height: 30), textColor: color)
        }
        
        
        let customBarButtonItem = UIBarButtonItem(image: arrowImage!, style: .plain, target: self, action: #selector(onBackHandler))
        customBarButtonItem.setIcon(icon: .ionicons(.iosArrowBack), iconSize: 25, color: color)
        
        
        navigationBarItem.leftBarButtonItems = []
        navigationBarItem.rightBarButtonItems = []
        navigationBarItem.leftBarButtonItems?.append(customBarButtonItem)
        
    }
    
    @objc func onBackHandler()  {
        self.dismiss(animated: true)
    }
    
    var viewManager: LoaderViewManager =  LoaderViewManager()
    
    func setupViewloader()  {
        
        //setup view loader, Error, Empty layouts
        viewManager.setup(parent: self.view)
        viewManager.getEmptyLayout().delegate = self
        viewManager.getErrorLayout().delegate = self
       
    }
    
    override func viewDidLoad() {
        
        setupNavBarTitles()
        setupNavBarButtons()
        

        load_delivery_analytics()
       
    }
    
    
    func load_delivery_analytics()  {
        
        guard let sess = Session.getInstance(), let user = sess.user else {
            viewManager.showAsError()
            return
        }
        
        stackview.removeAllArrangedSubviews()
        viewManager.showAsLoading(parent: self.view)
        
        let api = SimpleRequestApi()
        
        let parameters = [
            "user_token": user.token,
            "user_id": String(user.id)
        ]
        
        api.run(url: Constances.Api.API_GET_D_PROFILE_ANALYTICS, parameters: parameters) { (parser) in
            
            Utils.printDebug("\(parser)")
           
            if let p = parser, p.success == 1, let result = p.result {
                
                self.viewManager.showResult()
                
                
                Utils.printDebug("\(result["today"].stringValue)")
            
                self.render_component(title0: "Today".localized, value: result["today"].stringValue)
                self.render_component(title0: "Yesterday".localized, value: result["yesterday"].stringValue)
                self.render_component(title0: "This week".localized, value: result["this_week"].stringValue)
                self.render_component(title0: "This month".localized, value: result["this_month"].stringValue)
                self.render_component(title0: "Last month".localized, value: result["last_month"].stringValue)
                self.render_component(title0: "Current Balance".localized, value: result["wallet"].stringValue,color: Colors.green)
                self.render_component(title0: "Last payment".localized, value: result["last_payment"].stringValue)
                
            }else{
                
                self.viewManager.showAsError()
                
                
            }
        }
        
    }
    
    func render_component(title0: String, value: String, color: UIColor = .black) {
        //
        let title = TextLine.newInstance()
        title.header(title: title0)
        self.stackview.addArrangedSubview(title)
        title.heightAnchor.constraint(equalToConstant: 40).isActive = true
       
        let v = UILabel.new(label_text: value)
        
        if color != UIColor.black{
            v.textColor = color
            v.initBolodFont()
        }
      
        self.stackview.addArrangedSubview(v)
        
        let space1  =  TextLine.newInstance()
        space1.line.isHidden = true
        self.stackview.addArrangedSubview(space1)
        space1.heightAnchor.constraint(equalToConstant: 20).isActive = true
        
    }
    
    func onReloadAction(action: EmptyLayout) {
        
    }
    
    func onReloadAction(action: ErrorLayout) {
        
        load_delivery_analytics()
       
        
    }
    
   
}

