//
//  UserParser.swift
//  NearbyStores
//
//  Created by DT Team on 5/20/18.
//  Copyright © 2018 Amine. All rights reserved.
//


import UIKit

class OrderItemParser: Parser {
    
    
    func parse(order_id: Int) -> [OrderItem] {
        
        var list = [OrderItem]()
        
        
        if let myResult = self.result {
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    let myObject = OrderItem()
                    
                    myObject.id = object["id"].intValue
                    myObject.oi_id = UUID().uuidString
                    myObject.name = object["name"].stringValue
                    myObject.module = object["module"].stringValue
                    myObject.Qty = object["qty"].doubleValue
                    myObject.image = object["image"].stringValue
                    myObject.amount = object["amount"].doubleValue
                    
                    let currencyJSON = object["currency"]
                    let currencyParser = CurrencyParser(json: currencyJSON)
                                          
                    if let currency = currencyParser.parse() {
                        myObject.currency = currency
                    }
                    
                    list.append(myObject)
                    
                    
                }
                
                
            }
           
            return list
        }
        
        return []
    }
    
   
    
}



