//
//  MyUtils.swift
//  NearbyStores
//
//  Created by DT Team on 5/21/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftyJSON
import Alamofire
import SystemConfiguration
import AssistantKit



class AppDesignUtils {

    static func defaultModeColor(dark: UIColor, light: UIColor) -> UIColor {

        if (AppStyle.Config.uiColor == AppStyle.uiColor.dark) {
            return dark
        } else {
            return light
        }

    }

    static func darkColor() -> UIColor {

        if (AppStyle.Config.uiColor == AppStyle.uiColor.dark) {
            return Colors.darkIconColor
        } else {
            return Colors.primaryColor.withAlphaComponent(0.6)
        }

    }

    static func isDarkMode() -> Bool {

        if (AppStyle.Config.uiColor == AppStyle.uiColor.dark) {
            return true
        }

        return false
    }
}


extension UILabel {
    
    
    func calculateMaxLines2() -> Int {
        // Call self.layoutIfNeeded() if your view uses auto layout
        let myText = self.text! as NSString
        
        let rect = CGSize(width: self.bounds.width, height: CGFloat.greatestFiniteMagnitude)
        let labelSize = myText.boundingRect(with: rect, options: .usesLineFragmentOrigin, attributes: [NSAttributedString.Key.font: self.font], context: nil)
        
        return Int(ceil(CGFloat(labelSize.height) / self.font.lineHeight))
    }
    func calculateMaxLines() -> Int {
        let maxSize = CGSize(width: frame.size.width, height: CGFloat(Float.infinity))
        let charSize = font.lineHeight
        let text = (self.text ?? "") as NSString
        let textSize = text.boundingRect(with: maxSize, options: .usesLineFragmentOrigin, attributes: [NSAttributedString.Key.font: font], context: nil)
        let linesRoundedUp = Int(ceil(textSize.height/charSize))
        return linesRoundedUp
    }
}

extension String{
    
    enum RegularExpressions: String {
        case phone = "^\\s*(?:\\+?(\\d{1,3}))?([-. (]*(\\d{3})[-. )]*)?((\\d{3})[-. ]*(\\d{2,4})(?:[-.x ]*(\\d+))?)\\s*$"
    }
    
    func isValid(regex: RegularExpressions) -> Bool {
        return isValid(regex: regex.rawValue)
    }
    
    func isValid(regex: String) -> Bool {
        let matches = range(of: regex, options: .regularExpression)
        return matches != nil
    }
    
    func onlyDigits() -> String {
        let filtredUnicodeScalars = unicodeScalars.filter{CharacterSet.decimalDigits.contains($0)}
        return String(String.UnicodeScalarView(filtredUnicodeScalars))
    }
    
    func makeACall() {
        if isValid(regex: .phone) {
            if let url = URL(string: "tel://\(self.onlyDigits())"), UIApplication.shared.canOpenURL(url) {
                if #available(iOS 10, *) {
                    UIApplication.shared.open(url)
                } else {
                    UIApplication.shared.openURL(url)
                }
            }
        }
    }
}

class Connectivity {
    
    class func isConnected() -> Bool{
        
        var zeroAddress = sockaddr_in(sin_len: 0, sin_family: 0, sin_port: 0, sin_addr: in_addr(s_addr: 0), sin_zero: (0, 0, 0, 0, 0, 0, 0, 0))
        zeroAddress.sin_len = UInt8(MemoryLayout.size(ofValue: zeroAddress))
        zeroAddress.sin_family = sa_family_t(AF_INET)
        
        let defaultRouteReachability = withUnsafePointer(to: &zeroAddress) {
            $0.withMemoryRebound(to: sockaddr.self, capacity: 1) {zeroSockAddress in
                SCNetworkReachabilityCreateWithAddress(nil, zeroSockAddress)
            }
        }
        
        var flags: SCNetworkReachabilityFlags = SCNetworkReachabilityFlags(rawValue: 0)
        if SCNetworkReachabilityGetFlags(defaultRouteReachability!, &flags) == false {
            return false
        }
        
        
        // Working for Cellular and WIFI
        let isReachable = (flags.rawValue & UInt32(kSCNetworkFlagsReachable)) != 0
        let needsConnection = (flags.rawValue & UInt32(kSCNetworkFlagsConnectionRequired)) != 0
        let ret = (isReachable && !needsConnection)
        
        return ret
 
    }
}

class Utils {
    
     static func getIdFromPath(path: String,prefix: String) -> Int?{
           
           var list = path.components(separatedBy: "/")
           
           //clear list
           for (key,value) in list.enumerated() {
               if(value == ""){
                   list.remove(at: key)
               }
           }
           
           for key in 0...Int(list.count-1) {
               if(list[key] == ""){
                   list.remove(at: key)
               }
           }
           
           var lenght = Int(list.count-1)
           
           if(lenght<0){
               lenght = 0
           }
           
           for key in 0...lenght {
               if list[key] == prefix{
                   let next_index = key+1
                   if (list[next_index] == "dp" || list[next_index] == "id"){
                       let last_index = key+2
                       if let id = Int(list[last_index]){
                           if id>0{
                               return id
                           }
                       }
                   }
               }
           }
           
           return nil
           
       }
    
    static func isRTL() -> Bool  {
        
        if UIApplication.shared.userInterfaceLayoutDirection == .rightToLeft {
            return true
        }
        
        return false
    }
    
    
    static func convertToDictionary(text: String) -> JSON? {
        
        if let dataFromString = text.data(using: .utf8, allowLossyConversion: false) {
            
            do {
                return try JSON(data: dataFromString)
            } catch {
                print(error.localizedDescription)
            }
        }
        
        return nil
    }
    
    
    static func setFontRegular(labels: UILabel...){
        
        for view in labels {
            let font = UIFont(name: AppConfig.Design.Fonts.regular, size: view.font.pointSize)
            view.font = font
        }
        
    }
    
    static func setFontBold(labels: UILabel...){
        
        for view in labels {
            let font = UIFont(name: AppConfig.Design.Fonts.bold, size: view.font.pointSize)
            view.font = font
        }
        
    }
    
    
    
    static func printDebug(_ message: String){
        
        if AppConfig.DEBUG {
            print(message)
        }
        
    }
    
    static func printDebug(_ tag: String,_ message: String){
        
        if AppConfig.DEBUG {
            print("Debug ***\(tag) ****===> ",message)
        }
        
    }
    
    static func hexStringToUIColor (hex:String) -> UIColor {
        var cString:String = hex.trimmingCharacters(in: .whitespacesAndNewlines).uppercased()
        
        if (cString.hasPrefix("#")) {
            cString.remove(at: cString.startIndex)
        }
        
        if ((cString.count) != 6) {
            return UIColor.gray
        }
        
        var rgbValue:UInt32 = 0
        Scanner(string: cString).scanHexInt32(&rgbValue)
        
        return UIColor(
            red: CGFloat((rgbValue & 0xFF0000) >> 16) / 255.0,
            green: CGFloat((rgbValue & 0x00FF00) >> 8) / 255.0,
            blue: CGFloat(rgbValue & 0x0000FF) / 255.0,
            alpha: CGFloat(1.0)
        )
    }
    
}


extension UILabel{
    
    func useFontRegular(){
        
        let font = UIFont(name: AppConfig.Design.Fonts.regular, size: self.font.pointSize)
        self.font = font
        
    }
    
    
    func useFontBold(){
        
        let font = UIFont(name: AppConfig.Design.Fonts.regular, size: self.font.pointSize)
        self.font = font
        
    }
}


extension UIButton{
    
    func useFontRegular(){
        
        let font = UIFont(name: AppConfig.Design.Fonts.regular, size: (self.titleLabel?.font.pointSize)!)
        self.titleLabel?.font = font
        
    }
    
    
    func useFontBold(){
        
        let font = UIFont(name: AppConfig.Design.Fonts.bold, size: (self.titleLabel?.font.pointSize)!)
        self.titleLabel?.font = font
        
        
    }
    
}


extension UIView{
    
    
    
}

extension UITextView{
    func initDefaultFont(){
        if let font = self.font{
            let size = font.pointSize
            self.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size)
        }else{
            self.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 16)
        }
    }
    
    func initDefaultFont(size: CGFloat){
        self.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size)
    }
    
    func initBolodFont(){
        if let font = self.font{
            let size = font.pointSize
            self.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size)
        }else{
            self.font = UIFont(name: AppConfig.Design.Fonts.bold, size: 16)
        }
    }
    
    func initBolodFont(size: CGFloat){
        self.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size)
    }
}

extension UIButton{
    
    func setCustomText(string: String){
        
        let size =  self.titleLabel?.font.pointSize
        let font = UIFont(name: AppConfig.Design.Fonts.regular, size: size!.adaptScreen())
        let attributes = [NSAttributedString.Key.font: font]
        let attributedString = NSAttributedString(string: string, attributes: attributes)
        
        self.setAttributedTitle(attributedString, for: .normal)
        
    }
    
    func initDefaultFont(){
        let size = self.titleLabel?.font.pointSize
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size!)
    }
       
    func initDefaultFont(size: CGFloat){
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size)!
    }
    
    func initBoldFont(){
        let size = self.titleLabel?.font.pointSize
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size!)
    }
       
    func initBoldFont(size: CGFloat){
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size)!
    }
    
    
    func initItalicFont(){
        let size = self.titleLabel?.font.pointSize
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.italic, size: size!)
    }
       
    func initItalicFont(size: CGFloat){
        self.titleLabel?.font = UIFont(name: AppConfig.Design.Fonts.italic, size: size)!
    }
}


extension UILabel{
    
    
    func initDefaultFont(){
        let size = self.font.pointSize
        self.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size)
    }
    

    func initDefaultFont(size: CGFloat){
        self.font = UIFont(name: AppConfig.Design.Fonts.regular, size: size)
    }
    
    func initBolodFont(){
        let size = self.font.pointSize
        self.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size)
    }
    
    func initBolodFont(size: CGFloat){
        self.font = UIFont(name: AppConfig.Design.Fonts.bold, size: size)
    }
    
    func initItalicFont(){
           let size = self.font.pointSize
           self.font = UIFont(name: AppConfig.Design.Fonts.italic, size: size)
       }
       
       func initItalicFont(size: CGFloat){
           self.font = UIFont(name: AppConfig.Design.Fonts.italic, size: size)
       }
    
    func setLeftIcon(image: UIImage) {
        
        let imageAttachment =  NSTextAttachment()
        imageAttachment.image = image
        //Set bound to reposition
        let imageOffsetY:CGFloat = -5.0;
        imageAttachment.bounds = CGRect(x: 0, y: imageOffsetY, width: imageAttachment.image!.size.width, height: imageAttachment.image!.size.height)
        //Create string with attachment
        let attachmentString = NSAttributedString(attachment: imageAttachment)
        //Initialize mutable string
        let completeText = NSMutableAttributedString(string: "")
        //Add image to mutable string
        completeText.append(attachmentString)
        //Add your text to mutable string
        let  textAfterIcon = NSMutableAttributedString(string: self.text!)
        completeText.append(textAfterIcon)
        
        if Utils.isRTL(){
            self.textAlignment = .right;
        }else{
            self.textAlignment = .left;
        }
        
        self.attributedText = completeText;
    }
    
    
    func setRightIcon(image: UIImage) {
        
        let imageAttachment =  NSTextAttachment()
        imageAttachment.image = image
        //Set bound to reposition
        let imageOffsetY:CGFloat = -5.0;
        imageAttachment.bounds = CGRect(x: 0, y: imageOffsetY, width: imageAttachment.image!.size.width, height: imageAttachment.image!.size.height)
        //Create string with attachment
        let attachmentString = NSAttributedString(attachment: imageAttachment)
        //Initialize mutable string
        let completeText = NSMutableAttributedString(string: "")
        //Add image to mutable string
        
        //Add your text to mutable string
        let  textAfterIcon = NSMutableAttributedString(string: self.text!)
        completeText.append(textAfterIcon)
        completeText.append(attachmentString)
       
        if Utils.isRTL(){
            self.textAlignment = .right;
        }else{
            self.textAlignment = .left;
        }
        
        self.attributedText = completeText;
    }
    
    
    
    
}


extension UITableView {
    
    func scrollToLast() {
        
        let lastSectionIndex = self.numberOfSections - 1 // last section
        if(lastSectionIndex>=0){
            let lastRowIndex = self.numberOfRows(inSection: lastSectionIndex) - 1 // last row
            self.scrollToRow(at: IndexPath(row: lastRowIndex, section: lastSectionIndex), at: .bottom, animated: true)
        }
      
    }
    
    func scrollToLast(offset: Bool) {
        

        let scrollPoint = CGPoint(x: 0, y: self.contentSize.height - self.frame.size.height)
        self.setContentOffset(scrollPoint, animated: false)
        
    }
    
    
}

extension UICollectionView {
    

    
    func scrollToLast() {
        guard numberOfSections > 0 else {
            return
        }
     
        let lastItemIndex = numberOfItems(inSection: 0) > 0 ? numberOfItems(inSection: 0) - 1 : 0
        
        guard numberOfItems(inSection: 0) > 0 else {
            return
        }
        
        let lastItemIndexPath = IndexPath(item: lastItemIndex,
                                          section: 0)
        
        scrollToItem(at: lastItemIndexPath, at: .bottom, animated: true)
    }
    
}

class Localization {
    static var list_to_translate:[String:String] = [:]
}


extension UIScrollView {
    
    func resizeScrollViewContentSize() {
        
        var contentRect = CGRect.zero
        for view in self.subviews {
            contentRect = contentRect.union(view.frame)
        }
        
        self.contentSize = contentRect.size
    
    }
    
}


extension String {
    
    var localized: String {
        
        if AppConfig.DEBUG{
           Localization.list_to_translate[self] = self
        }
        
        return NSLocalizedString(self, tableName: nil, bundle: Bundle.main, value: "", comment: "")
    }
    
    func localized(withComment:String) -> String {
        return NSLocalizedString(self, tableName: nil, bundle: Bundle.main, value: "", comment: withComment)
    }
    
    func format(arguments: CVarArg...) -> String {
        let text: String = self
        return String(format: text, arguments: arguments)
    }
    
}

extension UIView {
    
    func addTopRoundedCornerToView(desiredCurve:CGFloat?)
    {
    
        let offset:CGFloat =  self.frame.width/desiredCurve!
        let bounds: CGRect = self.bounds
        
        let rectBounds: CGRect = CGRect(x:bounds.origin.x,y:  bounds.origin.y+bounds.size.height / 2, width: bounds.size.width,height:  bounds.size.height / 2)
        
        let rectPath: UIBezierPath = UIBezierPath(rect: rectBounds)
        let ovalBounds: CGRect = CGRect(x: bounds.origin.x - offset ,y:  bounds.origin.y,width:  bounds.size.width + offset,height: bounds.size.height)
        let ovalPath: UIBezierPath = UIBezierPath(ovalIn: ovalBounds)
        rectPath.append(ovalPath)
        
        // Create the shape layer and set its path
        let maskLayer: CAShapeLayer = CAShapeLayer()
        maskLayer.frame = bounds
        maskLayer.path = rectPath.cgPath
        
        // Set the newly created shape layer as the mask for the view's layer
        self.layer.mask = maskLayer
    }
}


extension UIView {

    func addShadowView(width:CGFloat=1, height:CGFloat=0.9, opcaity:Float=0.1, maskToBounds:Bool=false, radius:CGFloat=5)-> UIView{
        self.layer.shadowColor = UIColor.black.cgColor
        self.layer.shadowOffset = CGSize(width: width, height: height)
        self.layer.shadowRadius = radius
        self.layer.shadowOpacity = opcaity
        self.layer.masksToBounds = maskToBounds
        
         return self
    }

}


extension UIView {
    

       func roundCorners(corners: UIRectCorner, radius: CGFloat) {
            
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
               
                let path = UIBezierPath(roundedRect: self.bounds, byRoundingCorners: corners, cornerRadii: CGSize(width: radius, height: radius))
                let mask = CAShapeLayer()
                mask.path = path.cgPath
                self.layer.mask = mask
            
            }
        
        }
 
    
    func roundCorners(radius: CGFloat) -> UIView {
        
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.layer.cornerRadius = radius
            self.layer.masksToBounds = true
        }
        
        return self
    }
    
    func roundedCorners(radius: CGFloat) {
        
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.layer.cornerRadius = radius/UIScreen.main.nativeScale
            self.layer.masksToBounds = true
        }
        
       
    }
    
    
    func border(with: CGFloat, color: UIColor) {
        
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.layer.borderWidth = with
            self.layer.borderColor = color.cgColor
        }

    }
}



extension Float {
    func adaptScreen() -> Float {
        var ratio = 1.0
        switch Device.screen {
        case .inches_3_5:  ratio = 1.2
        case .inches_4_0:  ratio = 1.18
        case .inches_4_7:  ratio = 1.12
        case .inches_5_5:  ratio = 1.10
        case .inches_7_9:  ratio = 1.09
        case .inches_9_7:  ratio = 1.05
        case .inches_12_9: ratio = 0.9
        default:        ratio = 1.0
        }
        return self / Float(ratio)
    }
}

extension CGFloat {
    func adaptScreen() -> CGFloat {
        var ratio = 1.0
        switch Device.screen {
        case .inches_3_5:  ratio = 1.2
        case .inches_4_0:  ratio = 1.18
        case .inches_4_7:  ratio = 1.12
        case .inches_5_5:  ratio = 1.10
        case .inches_7_9:  ratio = 1.09
        case .inches_9_7:  ratio = 1.05
        case .inches_12_9: ratio = 0.9
        default:        ratio = 1.0
        }
        return self / CGFloat(ratio)
    }
}


extension AppConfig.Design.Colors{
    static let darkIconColor = "#B71C1C"
}



extension String {
    var isNumeric : Bool {
        return Double(self) != nil
    }
}

extension String {

    var isRTL: Bool {
        

    
        var string  = self
        string = string.replacingOccurrences(of: ".", with: " ")
        string = string.replacingOccurrences(of: "،", with: " ")
        
        var value = ""
     
        let list = string.split(separator: " ")
        for index in 0...(list.count-1) {
            if(!String(list[index]).isNumeric){
                value = String(list[index])
                break
            }
        }
        
        
        value = value.replacingOccurrences(of: ".", with: "")
        let cleanFile = value.replacingOccurrences(of: "\r", with: "\n")
        var newLineIndices: Array<Int> = []

        for (index, char) in cleanFile.enumerated() {
            if char == "\n" {
                newLineIndices.append(index)
            }
        }

        newLineIndices.insert(-1, at: 0)
        newLineIndices.append(cleanFile.count)

        let tagschemes = NSArray(objects: NSLinguisticTagScheme.language)
        let tagger = NSLinguisticTagger(tagSchemes: tagschemes as! [NSLinguisticTagScheme], options: 0)
        tagger.string = cleanFile

        for i in 0..<newLineIndices.count - 1 {
            
            let language = tagger.tag(at: newLineIndices[i + 1] - 1, scheme: NSLinguisticTagScheme.language, tokenRange: nil, sentenceRange: nil)

            if String(describing: language).range(of: "he") != nil || String(describing: language).range(of: "ar") != nil || String(describing: language).range(of: "fa") != nil {
                return true
            } else {
                
                if String(describing: language).range(of: "und") != nil && Utils.isRTL(){
                    return true
                }else{
                    return false
                }
                
                
            }
        }

        return false
    }
    

    var isLTR: Bool {
        
    
        
        var value = ""
            
        let list = self.split(separator: " ")
        for index in 0...(list.count-1) {
            if(!String(list[index]).isNumeric){
                value = String(list[index])
                break
            }
        }
        
       
        let cleanFile = value.replacingOccurrences(of: "\r", with: "\n")
        var newLineIndices: Array<Int> = []

        for (index, char) in cleanFile.enumerated() {
            if char == "\n" {
                newLineIndices.append(index)
            }
        }

        newLineIndices.insert(-1, at: 0)
        newLineIndices.append(cleanFile.count)

        let tagschemes = NSArray(objects: NSLinguisticTagScheme.language)
        let tagger = NSLinguisticTagger(tagSchemes: tagschemes as! [NSLinguisticTagScheme], options: 0)
        tagger.string = cleanFile

        for i in 0..<newLineIndices.count - 1 {
            let language = tagger.tag(at: newLineIndices[i + 1] - 1, scheme: NSLinguisticTagScheme.language, tokenRange: nil, sentenceRange: nil)

            if String(describing: language).range(of: "he") != nil || String(describing: language).range(of: "ar") != nil || String(describing: language).range(of: "fa") != nil {
                return false
            } else {
                if String(describing: language).range(of: "und") != nil && !Utils.isRTL(){
                    return false
                }else{
                    return true
                }
            }
        }

        return false
    }

}



extension UILabel{
    
    static func newKV(label_text: String, label_value: String) -> UILabel {
        
        let my_label_text = UILabel()
        my_label_text.initDefaultFont(size: 14)
        my_label_text.numberOfLines = 0
        my_label_text.text = ""
        
        let html = "<b>\(label_text): </b> "+label_value
        my_label_text.attributedText = html.toHtml().attributedString
        my_label_text.initDefaultFont(size: 14)
        return my_label_text
    }
    
    static func new(label_text: String) -> UILabel {
           let my_label_text = UILabel()
           my_label_text.initDefaultFont(size: 14)
           my_label_text.numberOfLines = 0
           my_label_text.text = label_text
           return my_label_text
       }
    
    
    
}


extension EdgeLabel{
    
    @objc static func new_edge_label(label_text: String) -> EdgeLabel {
           let my_label_text = EdgeLabel()
           my_label_text.initDefaultFont(size: 14)
           my_label_text.numberOfLines = 0
           my_label_text.text = label_text
           return my_label_text
       }
    
}


extension UIStackView {
    
    func removeAllArrangedSubviews() {
        
        let removedSubviews = arrangedSubviews.reduce([]) { (allSubviews, subview) -> [UIView] in
            self.removeArrangedSubview(subview)
            return allSubviews + [subview]
        }
        
        // Deactivate all constraints
        NSLayoutConstraint.deactivate(removedSubviews.flatMap({ $0.constraints }))
        
        // Remove the views from self
        removedSubviews.forEach({ $0.removeFromSuperview() })
    }
}

class GeoUtils{
    
   
    ///////////////////////////////////////////////////////////////////////
    ///  This function converts decimal degrees to radians              ///
    ///////////////////////////////////////////////////////////////////////
    static func deg2rad(deg:Double) -> Double {
        return deg * M_PI / 180
    }

    ///////////////////////////////////////////////////////////////////////
    ///  This function converts radians to decimal degrees              ///
    ///////////////////////////////////////////////////////////////////////
    static func rad2deg(rad:Double) -> Double {
        return rad * 180.0 / M_PI
    }

    static func distance(lat1:Double, lon1:Double, lat2:Double, lon2:Double, unit:String) -> Double {
        let theta = lon1 - lon2
        var dist = sin(deg2rad(deg: lat1)) * sin(deg2rad(deg: lat2)) + cos(deg2rad(deg: lat1)) * cos(deg2rad(deg: lat2)) * cos(deg2rad(deg: theta))
        dist = acos(dist)
        dist = rad2deg(rad: dist)
        dist = dist * 60 * 1.1515
        if (unit == "K") {
            dist = dist * 1.609344
        }
        else if (unit == "N") {
            dist = dist * 0.8684
        }
        return dist
    }

    
}



