//
//  MyApi.swift
//  NearbyStores
//
//  Created by DT Team on 7/25/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import Alamofire

class MyApi {
    
    var httpHeaders: HTTPHeaders = [
        "Api-key-ios": AppConfig.Api.ios_api,
        "Api-app-id": "df-ios",
        "Debug": "\(AppConfig.DEBUG)",
        "Token": LocalData.getValue(key: "token", defaultValue: ""),
        "Language": LocalData.getValue(key: "language", defaultValue: ""),
        "Current-date": DateUtils.getCurrent(format: DateFomats.defaultFormatUTC),
        "Timezone":TimeZone.current.abbreviation()!
    ]
    
    func prepareRequest () {
        
        if let sess = Session.getInstance(), let user = sess.user{
            self.httpHeaders["Session-user-id"] = String(user.id)
            self.httpHeaders["Authorization"] = "Bearer \(String(user.token))"
            self.httpHeaders["Authentication"] = "Bearer \(String(user.token))"
        }
       
        if let guest = Guest.getInstance(){
            self.httpHeaders["Session-guest-id"] = String(guest.id)
        }
        
        Utils.printDebug("httpHeaders \(self.httpHeaders)")
    }
 

}
