//
//  AppConfig.swift
//  AppTest
//
//  Created by DT Team on 5/14/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons

class AppConfig: NSObject {
    
    //AppConfiguration
    static let DEBUG: Bool = true
    
    //Maps Config
    static let GOOGLE_MAPS_KEY = "*** Google API key ***"
    static let GOOGLE_PLACES_KEY = GOOGLE_MAPS_KEY
    static let GOOGLE_DIRECTIONS_KEY = "*** Google API key ***"
    
    
    //API SERVER CONFIG
    struct Api {
        static let ios_api              = "*** Android API key ***"    // get it from dashboard
        static let base_url             = "https://domain.com/index.php"
        static let base_url_api         = "https://domain.com/index.php/api"
        static let terms_of_use_url     = "https://domain.com/term_of_uses.html"
        static let privacy_policy_url   = "https://domain.com/privacy_policy.html"
    }
    
    
    struct DeepLinking {
        
        static let host                   = "domain.com"
        
    }

    
    
    //App Name
    static let APP_NAME = Bundle.main.infoDictionary?["CFBundleName"] as! String
    
    
    //Enable/Disable Chat in your App
    static let CHAT_ENABLED = true
    
    
    
    
    //Config Colors & Fonts
    struct Design {
        
        //Some proposed colors from google
        //https://material.io/design/color/the-color-system.html
        enum Colors {
            
            static let primaryColor = "#ff4800"
            static let accentColor = "#ff632b"
            static let darkColor = "#d33e08"
            
            /* Background Colors */
            static let first_color = "#ff4800"
            static let second_color = "#ff8300"

            static let featuredTagColor = "#1565C0"
            static let promoTagColor = "#E53935"
            static let dealColor = "#F4B400"
            static let upComingColor = "#E65100"
            static let blackColor = "#050000"

        }
        
        //See how to set custom font
        //https://developer.apple.com/documentation/uikit/text_display_and_fonts/adding_a_custom_font_to_your_app
        enum Fonts {
            static let regular = "Montserrat-Regular"
            static let italic = "Montserrat-Italic"
            static let bold = "Montserrat-SemiBold"
        }
        
        
            
        
    }
    
    //Main Config
    struct Tabs {
        
        enum Tags {
            static let TAG_ORDER = "orders"
            static let TAG_MANAGED_ORDER = "managed_orders"
            static let TAG_GEO = "geo_stores"
            static let TAG_INBOX = "inbox"
          
        }
        
        static var Pages: [String] = [
            Tags.TAG_ORDER,  // Geo Maps
            Tags.TAG_MANAGED_ORDER,  // Managed orders
            Tags.TAG_INBOX,  // Inbox
        ]
        
        static var TabIcons: [String: String] = [
            Tags.TAG_ORDER:  "tab_icon_5",
            Tags.TAG_MANAGED_ORDER:  "tab_icon_1",
            Tags.TAG_INBOX:  "tab_icon_4",
        ]
        
    }
    
    static let distanceMaxValue = 100 //By KM
    static let distanceUnit = Distance.Types.Kilometers
    
    
    
    
    //About Company Or Project
    struct About {
        
        static let ABOUT_US = "Dealify is a powerful online Deals system with an intelligent search functionality that can help you find best deals in a specific area so quickly and efficiently ."
        
        static let EMAIL = "contact@droidev-tech.com"
        static let TEL = "+1 000 000 00"
    }
    
    
  
    
    struct Settings {
        static let useAsBusinessManeger = false
        static let enableSocialMediaAuth = true
    }
    
    
    //Enable/Disable Menu Items
    struct Menu {
        /*
         to manage menu list, should remove each id from the list
         */
        static let list = [
            MenuIDList.WALLET : true,
            MenuIDList.CHAT_LOGIN : true,
            MenuIDList.EDIT_PROFILE : true,
            MenuIDList.LOGOUT : true,
            MenuIDList.SETTING : true,
            MenuIDList.ABOUT : true,
            MenuIDList.CLOSE : true,
            ]
    }
    
    let app_version = "1.0.0" // please don't touch this
    
    
    
    
}
