package com.droideve.apps.dealify.utils;

import com.droideve.apps.dealify.classes.Currency;

/**
 * Created by Droideve on 1/26/2018.
 */

public class ProductUtils {


    public static String parseCurrencyFormat(float price, Currency cData) {


        if (cData != null) {
            String ps = String.format("%." + cData.getCfd() + "f", price);
            ps = ps.replace(".", cData.getCdp());


            //parse format
            switch (cData.getFormat()) {
                case 1:
                    return cData.getSymbol() + ps;
                case 2:
                    return ps + cData.getSymbol();
                case 3:
                    return cData.getSymbol() + " " + ps;
                case 4:
                    return ps + " " + cData.getSymbol();
                case 5:
                    return ps;
                case 6:
                    return cData.getSymbol() + ps + " " + cData.getCode();
                case 7:
                    return cData.getSymbol() + ps;
                case 8:
                    return ps + cData.getCode();
            }


        }


        return String.valueOf(price);


    }


}
