package com.droideve.apps.dealify.push_notification_firebase;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

import com.droideve.apps.dealify.Services.NotifyDataNotificationEvent;
import com.droideve.apps.dealify.appconfig.AppConfig;
import com.droideve.apps.dealify.classes.Notification;
import com.droideve.apps.dealify.controllers.CampagneController;
import com.droideve.apps.dealify.dtmessenger.InComingDataParserSender;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

import static com.droideve.apps.dealify.appconfig.AppConfig.APP_DEBUG;


public class DTNotificationManager {

    private final Map<String, String> data;
    private final Context context;

    public DTNotificationManager(Context context, Map<String, String> data) {
        this.data = data;
        this.context = context;
    }

    public void push() {

        String incomingData = "";
        /*
            parse incoming data to client message
         */

        if (data.containsKey("type") && data.get("type").equals(Tags.NOTIFICATION)
                && AppConfig.CHAT_WITH_FIREBASE && AppConfig.ENABLE_CHAT) {

            incomingData = data.get("data");

            try {
                InComingDataParserSender.parseAndSend(context, new JSONObject(incomingData));
            } catch (JSONException e) {
                if (AppConfig.APP_DEBUG)
                    e.printStackTrace();
            }

            return;
        } else if (data.containsKey("type") && data.get("type").equals(Tags.CAMPAIGN)) {

            /*
                parse incoming data to client compaign
             */
            incomingData = data.get("data");
            parse(incomingData);
        } else {

            //push counter to all badges
            Notification.notificationsUnseen = Notification.notificationsUnseen + 1;
            EventBus.getDefault().postSticky(new NotifyDataNotificationEvent("update_badges"));
            EventBus.getDefault().post(new NotifyDataNotificationEvent("recently_added"));
        }

    }

    public void parse(String incomingData) {

        if (APP_DEBUG) {
            Log.e("incomingData", incomingData);
        }

        Parser mParser = null;
        try {
            mParser = new Parser(incomingData);
            mParser.parse();
        } catch (JSONException e) {
            e.printStackTrace();
            return;
        }

        if (AppConfig.APP_DEBUG)
            Log.e(FirebaseMessagingService.TAG, data.toString());

        try {
            CampagneController.markReceive(mParser.getCid());
        } catch (Exception e) {
        }

        int campaign_id = mParser.getCid();


        //push counter to all badges
        Notification.notificationsUnseen = Notification.notificationsUnseen + 1;
        EventBus.getDefault().postSticky(new NotifyDataNotificationEvent("update_badges"));


        //Refresh the list of the notification from the api
        //EventBus.getDefault().postSticky(new NotifyDataNotificationEvent("recently_added"));

    }

    public Bitmap getBitmapfromUrl(String imageUrl) {
        try {
            URL url = new URL(imageUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap bitmap = BitmapFactory.decodeStream(input);
            return bitmap;
        } catch (Exception e) {
            // TODO Auto-generated catch block
            if (AppConfig.APP_DEBUG)
                e.printStackTrace();
            return null;

        }
    }

    public static class Tags {

        public final static String CAMPAIGN = "campaign";
        public final static String NOTIFICATION = "notification";

        public final static String TITLE = "title";
        public final static String SUB_TITLE = "sub-title";
        public final static String BODY = "body";
        public final static String ID = "id";
        public final static String IMAGE = "image";
        public final static String TYPE = "type";
        public final static String CAMPAGNE_ID = "cid";

        public final static String PRODUCT_PRICE = "price";
        public final static String PRODUCT_PERCENT = "percent";
        public final static String PRODUCT_DESCRIPTION = "description";
        public final static String PRODUCT_ATTACHMENT = "attachment";
        public final static String PRODUCT_CURRENCY = "currency";
        public final static String PRODUCT_STORE_NAME = "store_name";
    }

    public static class Parser {

        public static String STORE = "store";
        public static String PRODUCT = "product";
        public static String EVENT = "event";

        private final JSONObject data;
        private String type;
        private int id;
        private String title;
        private String sub_title;
        private String image;
        private BodyParser body;
        private int cid;

        public Parser(String data) throws JSONException {
            this.data = new JSONObject(data);
        }

        public String getImage() {
            return image;
        }

        public int getCid() {
            return cid;
        }

        public void parse() throws JSONException {

            id = data.getInt(Tags.ID);
            type = data.getString(Tags.TYPE);
            title = data.getString(Tags.TITLE);
            sub_title = data.getString(Tags.SUB_TITLE);

            image = data.getString(Tags.IMAGE);
            cid = data.getInt(Tags.CAMPAGNE_ID);

            if (data.has(Tags.BODY) && type.equals(Parser.PRODUCT)) {
                String body = data.getString(Tags.BODY);
                this.body = new BodyParser(body);
                this.body.parse();
            }


        }

        public String getSub_title() {
            return sub_title;
        }

        public String getType() {
            return type;
        }

        public int getId() {
            return id;
        }

        public String getTitle() {
            return title;
        }

        public BodyParser getBody() {
            return body;
        }


        @Override
        public String toString() {
            return "Parser{" +
                    "type='" + type + '\'' +
                    ", id=" + id +
                    ", title='" + title + '\'' +
                    ", body='" + body + '\'' +
                    ", image='" + image + '\'' +
                    '}';
        }


        class BodyParser {


            private double price;
            private double percent;
            private String currency;
            private String description;
            private String attachement;
            private String storeName;
            private JSONObject json;


            public BodyParser(String body) {
                try {
                    json = new JSONObject(body);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void parse() {
                if (json != null) {
                    try {
                        price = json.getDouble(Tags.PRODUCT_PRICE);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    try {
                        percent = json.getDouble(Tags.PRODUCT_PERCENT);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    try {
                        currency = json.getString(Tags.PRODUCT_CURRENCY);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    try {
                        description = json.getString(Tags.PRODUCT_DESCRIPTION);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    try {
                        attachement = json.getString(Tags.PRODUCT_ATTACHMENT);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    try {
                        storeName = json.getString(Tags.PRODUCT_STORE_NAME);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }


            public String getAttachement() {
                return attachement;
            }

            public String getStoreName() {
                return storeName;
            }

            @Override
            public String toString() {
                return "BodyParser{" +
                        "price=" + price +
                        ", percent=" + percent +
                        ", currency='" + currency + '\'' +
                        ", description='" + description + '\'' +
                        ", attachement='" + attachement + '\'' +
                        ", storeName='" + storeName + '\'' +
                        '}';
            }
        }

    }


}
