package com.droideve.apps.dealify.parser.api_parser;


import com.droideve.apps.dealify.classes.Order;
import com.droideve.apps.dealify.parser.Parser;
import com.droideve.apps.dealify.parser.tags.Tags;

import org.json.JSONException;
import org.json.JSONObject;

import io.realm.RealmList;


public class OrderParser extends Parser {

    public OrderParser(JSONObject json) {
        super(json);
    }
    public OrderParser(Parser parser) {
        this.json = parser.json;
    }

    public RealmList<Order> getOrders() {

        RealmList<Order> list = new RealmList<>();

        try {

            JSONObject json_array = json.getJSONObject(Tags.RESULT);

            for (int i = 0; i < json_array.length(); i++) {


                try {
                    JSONObject json_order = json_array.getJSONObject(i + "");
                    Order order = new Order();
                    order.setId(json_order.getInt("id"));
                    order.setStatus(json_order.getString("status"));
                    order.setDelivery_id(json_order.getInt("delivery_id"));
                    order.setStatus_id(json_order.getInt("status_id"));
                    order.setUser_id(json_order.getInt("user_id"));
                    order.setName(json_order.getString("name"));
                    order.setId_store(json_order.getInt("id_store"));
                    order.setUpdated_at(json_order.getString("updated_at"));
                    order.setCreated_at(json_order.getString("created_at"));
                    order.setDelivery_commission(json_order.getDouble("delivery_commission"));


                    if (json_order.has("cart"))
                        order.setCart(json_order.getString("cart"));


                    if (json_order.has("delivery_status"))
                        order.setDelivery_status(json_order.getInt("delivery_status"));


                    if (json_order.has("payment_status_data"))
                        order.setPayment_status(json_order.getString("payment_status_data"));


                    if (json_order.has("req_cf_id"))
                        order.setReq_cf_id(json_order.getInt("req_cf_id"));

                    if (json_order.has("req_cf_data"))
                        order.setReq_cf_data(json_order.getString("req_cf_data"));


                    if (json_order.has("amount") && !json_order.isNull("amount"))
                        order.setAmount((float) json_order.getDouble("amount"));

                    if (json_order.has("timeline") && !json_order.isNull("timeline")) {
                        TimeLineParser timeLineParser = new TimeLineParser(new JSONObject(json_order.getString("timeline")));
                        order.setTimeLines(timeLineParser.getTimeLines());
                    }


                    if (json_order.has("extras") && !json_order.isNull("extras"))
                        order.setExtras(json_order.getString("extras"));

                    if (!json_order.isNull("items")) {
                        ItemParser items = new ItemParser(json_order);

                        if (items.getItems().size() > 0) {
                            order.setItems(items.getItems());
                        }
                    }

                    list.add(order);
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

        } catch (
                JSONException e) {
            e.printStackTrace();
        }


        return list;
    }


}
