package com.droideve.apps.dealify.fragments;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.droideve.apps.dealify.location.GPStracker;
import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.animation.Animation;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.LatLng;
import com.rey.material.widget.FloatingActionButton;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class OrdersMapsFragment extends Fragment implements OnMapReadyCallback {


    @BindView(R.id.item_focus_layout)
    LinearLayout item_focus_layout;

    @BindView(R.id.closeProductLayoutBtn)
    ImageView closeProductLayoutBtn;

    @BindView(R.id.item_new_order)
    LinearLayout storeProductsLayout;

    @BindView(R.id.fab)
    FloatingActionButton fab;


    @BindView(R.id.decline)
    Button decline;

    private GoogleMap mMap;
    private LatLng myPosition, destination;


    @OnClick(R.id.closeLayout)
    public void closeLocationDetail(View view) {
        item_focus_layout.setVisibility(View.GONE);
    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_map_new_order, container, false);
        //context = rootView.getContext();
        ButterKnife.bind(this, rootView);

        // Obtain the SupportMapFragment and get notified when the map is ready to be used.
        SupportMapFragment mapFragment = (SupportMapFragment) getChildFragmentManager()
                .findFragmentById(R.id.map);
        mapFragment.getMapAsync(this);

        switchToMaps();

        decline.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (storeProductsLayout.isShown())
                    Animation.hideWithZoomEffect(storeProductsLayout);
            }
        });
        closeProductLayoutBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (storeProductsLayout.isShown())
                    Animation.hideWithZoomEffect(storeProductsLayout);
            }
        });


        return rootView;


    }


    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        System.gc();
    }


    private void switchToMaps() {
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (getParentFragmentManager().findFragmentByTag("mapOrders") != null) {
                    // I'm viewing Fragment C
                    getParentFragmentManager().popBackStack("mapOrders",
                            FragmentManager.POP_BACK_STACK_INCLUSIVE);
                } else {
                    OrdersFragment frag = new OrdersFragment();
                    FragmentTransaction transaction = getChildFragmentManager().beginTransaction();
                    transaction.replace(R.id.main_container, frag, "mapOrders");
                    transaction.setCustomAnimations(R.anim.slide_in_left, R.anim.slide_out_right);
                    // Commit the transaction
                    transaction.commit();
                }

                // go back to something that was added to the backstack
                //getChildFragmentManager().popBackStackImmediate( "mapOrders", 0);


            }
        });
    }

    @Override
    public void onMapReady(GoogleMap googleMap) {
        mMap = googleMap;

        //my position tracker
        if (ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.ACCESS_FINE_LOCATION)
                != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(getContext(), Manifest.permission.ACCESS_COARSE_LOCATION)
                != PackageManager.PERMISSION_GRANTED) {
            return;
        }
        mMap.setMyLocationEnabled(true);


        //INITIALIZE MY LOCATION
        GPStracker trackMe = new GPStracker(getContext());
        myPosition = new LatLng(trackMe.getLatitude(), trackMe.getLongitude());

        if (mMap != null) {

            mMap.moveCamera(CameraUpdateFactory.newLatLngZoom(myPosition, 10));
            mMap.getUiSettings().setZoomControlsEnabled(true);

        }


    }


}