package com.droideve.apps.dealify.controllers.orders;

import com.droideve.apps.dealify.classes.Order;

import java.util.List;

import io.realm.Realm;
import io.realm.RealmList;
import io.realm.RealmResults;

/**
 * Created by Droideve on 11/12/2017.
 */

public class OrdersController {


    public static Order findOrderById(int id) {
        Realm realm = Realm.getDefaultInstance();
        return realm.where(Order.class).equalTo("id", id).findFirst();
    }


    public static List<Order> findMyOrders(final int delivery_id) {
        Realm realm = Realm.getDefaultInstance();
        return realm.where(Order.class).equalTo("delivery_id", delivery_id).findAll();
    }


    public static boolean insertOrders(final RealmList<Order> list) {

        Realm realm = Realm.getDefaultInstance();
        realm.executeTransaction(new Realm.Transaction() {
            @Override
            public void execute(Realm realm) {
                for (Order order : list) {
                    realm.copyToRealmOrUpdate(order);
                }
            }
        });
        return true;
    }


    public static void removeAll() {
        Realm realm = Realm.getDefaultInstance();
        if (realm.isInTransaction()) {
            realm.executeTransaction(new Realm.Transaction() {
                @Override
                public void execute(Realm realm) {
                    RealmResults<Order> result = realm.where(Order.class).findAll();
                    result.deleteAllFromRealm();
                }
            });
        }

    }

}
