package com.droideve.apps.dealify.activities;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.classes.Driver;
import com.droideve.apps.dealify.controllers.sessions.SessionsController;
import com.droideve.apps.dealify.location.GPStracker;
import com.droideve.apps.dealify.utils.NSLog;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

public class GlobalActivity extends AppCompatActivity {

    private final String TAG = "GlobalActivity";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);//  set status text dark
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            getWindow().setStatusBarColor(ContextCompat.getColor(getApplicationContext(), R.color.white));// set status background white
        }

        setupRealtimeDatabaseFire();

    }

    @Override
    protected void onStop() {
        super.onStop();


    }

    private DatabaseReference mDatabase;

    void setupRealtimeDatabaseFire(){

        // init firebase database
        mDatabase = FirebaseDatabase.getInstance().getReference();

        locationChanged();
    }

    private void locationChanged() {

        if(!SessionsController.isLogged())
            return;

        int userId = SessionsController.getSession().getUser().getId();

        //my position tracker
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION)
                != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION)
                != PackageManager.PERMISSION_GRANTED) {
            return;
        }

        LocationManager lm = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
        lm.requestLocationUpdates(LocationManager.GPS_PROVIDER, 10000, 0, new LocationListener() {
            @Override
            public void onLocationChanged(Location location) {
                Driver user = new Driver(userId,location.getLatitude(), location.getLongitude());
                mDatabase.child("users").child("user-" + userId).setValue(user);
            }
            @Override
            public void onProviderDisabled(String provider) {
                // TODO Auto-generated method stub
                NSLog.e(TAG, "onProviderDisabled");
            }

            @Override
            public void onProviderEnabled(String provider) {
                // TODO Auto-generated method stub
                NSLog.e(TAG, "onProviderEnabled");
            }

            @Override
            public void onStatusChanged(String provider, int status,
                                        Bundle extras) {
                NSLog.e(TAG, "onStatusChanged");
                // TODO Auto-generated method stub
            }
        });
    }



}
