
import UIKit

protocol V_OptionDelegate {
    func onClicked(group: VariantGroup,option: VariantOption)
}

class V_Option: UIView {
    
    var delegate: V_OptionDelegate? = nil
    
    enum Types {
        case Radio
        case Checkbox
    }
    
  
    static func newInstance(group: VariantGroup, option: VariantOption) ->  V_Option{
        
        let view:V_Option = UINib(nibName: "V_Option", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! V_Option
        
        view.heightAnchor.constraint(equalToConstant: 40).isActive = true
        view.setup(group: group, option: option)
        
        return view
    }
    
    @IBOutlet weak var check_icon: UIImageView!
    @IBOutlet weak var option_title: UILabel!
    @IBOutlet weak var option_value: UILabel!
    
    var group: VariantGroup? = nil
    var option: VariantOption? = nil
   
    func setup(group: VariantGroup, option: VariantOption){
        
        self.group = group
        self.option = option
        
        self.option_title.initDefaultFont(size: 16)
        self.option_title.textColor = .darkGray
        self.option_value.initBolodFont(size: 16)
        self.option_value.textColor = .red
    
        
        //set as unchecked
        if(group.group_type == "one_option"){
            uncheck_radio()
        }else if(group.group_type == "multi_options"){
            uncheck_checkbox()
        }
        
        
        self.option_title.text = option.label
       
        //set value
        if(group.group_type == "one_option"){
            
            if option.value > 0{
                self.option_value.text = "\(option.parsed_value)"
            }else{
                self.option_value.isHidden = true
            }
          
            
        }else if(group.group_type == "multi_options"){
            
            if option.value > 0{
                self.option_value.text = "+\(option.parsed_value)"
            }else{
                self.option_value.isHidden = true
            }
            
        }
        
        
        //register gesture reconizer for gallery
        let gestureRecognizer1 = UITapGestureRecognizer(target: self, action: #selector(didTapOnItem))
       
        self.addGestureRecognizer(gestureRecognizer1)
        self.isUserInteractionEnabled = true
        
        
    }
    
    var is_checked = false
    
    @objc func didTapOnItem()  {
        
        if let del = delegate, let grp = group, let opt = option{
            del.onClicked(group: grp, option: opt)
        }
        
    }
    
    func check_radio()  {
        
        let check_icon = UIImage(named: "check")
        self.check_icon.image = check_icon
        
        is_checked = true
       
        
    }
    
    func uncheck_radio()  {
        
        let uncheck_icon = UIImage(named: "uncheck")
        self.check_icon.image = uncheck_icon
    
        is_checked = false
       
    }
    
    
    func check_checknox()  {
        
        let check_icon = UIImage(named: "check-square")
        self.check_icon.image = check_icon
        
        is_checked = true
        
    }
    
    func uncheck_checkbox()  {
        
        let uncheck_icon = UIImage(named: "uncheck-square")
        self.check_icon.image = uncheck_icon
        
        is_checked = false
    
    }
    
    
    
}
