import UIKit
import RealmSwift

protocol V_Group_Update_Delegate {
    func onUpdated(group: VariantGroup)
}

class V_GroupResult : Object {
    @objc dynamic var grp_id: Int = 0
    @objc dynamic var grp_label: String = ""
    var options: List<VariantOption> = List<VariantOption>()
    @objc dynamic var calculated: Double = 0.0
}

class V_Group: UIView, V_OptionDelegate {
  
    var delagate: V_Group_Update_Delegate? = nil
    
    @IBOutlet weak var title: UILabel!
    @IBOutlet weak var container1: UIStackView!
    @IBOutlet weak var option_container: UIStackView!
    
    var group: VariantGroup? = nil
   
    
    //one_option / multi_option
    var type = "one_option"

    static func newInstance(group: VariantGroup) ->  V_Group{
        
        
        let view:V_Group = UINib(nibName: "V_Group", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! V_Group
    
        view.option_container.translatesAutoresizingMaskIntoConstraints = false
        view.group = group
        view.setup(group: group)
        
        
        return view
    }
    
    
    func setup(group: VariantGroup){
        
        self.heightAnchor.constraint(equalToConstant: CGFloat(( 40 * group.options.count) + 40) ).isActive = true
        
        self.title.initBolodFont(size: 18)
        self.title.text = group.group_label
        
        for option in group.options {
            let opt = V_Option.newInstance(group: group,option: option)
            opt.delegate = self
            self.option_container.addArrangedSubview(opt)
        }
      
    }
    
    
    
    func onClicked(group: VariantGroup, option: VariantOption) {
        
        
    
        if(group.group_type == "one_option"){
            
            //uncheck_all
            for subview in self.option_container.subviews{
                
                if subview is V_Option{
                   
                    let opt_view = subview as! V_Option
                
                    if opt_view.option?.id == option.id{
                        if opt_view.is_checked {
                            opt_view.uncheck_radio()
                        }else{
                            opt_view.check_radio()
                        }
                    }else{
                        if opt_view.is_checked {
                            opt_view.uncheck_radio()
                        }
                    }
                    
                }
                
            }
            
        
        }else if(group.group_type == "multi_options"){
            
            //uncheck_all
            for subview in self.option_container.subviews{
                
                if subview is V_Option{
                   
                    let opt_view = subview as! V_Option
                    
                    if opt_view.option?.id == option.id{
                        
                        if opt_view.is_checked {
                            opt_view.uncheck_checkbox()
                        }else{
                            opt_view.check_checknox()
                        }
                       
                    }
                   
                }
                
            }
            
        }
        
        if let del = delagate{
            del.onUpdated(group: group)
        }
        
    }
    
    
}
