//
//  UserParser.swift
//  NearbyStores
//
//  Created by Amine on 5/20/18.
//  Copyright © 2018 Amine. All rights reserved.
//

//
//  JobParser.swift
//  AppTest
//
//  Created by Amine on 5/15/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class VariantParser: Parser {
    
    
    func parse_group() -> [VariantGroup] {
        
        var list = [VariantGroup]()
        
        
        if let myResult = self.result {
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    let myObject = VariantGroup()
                    
                    
                  
                    myObject.group_id = object["group_id"].intValue
                    myObject.group_label = object["group_label"].stringValue
                    myObject.group_type = object["type"].stringValue
                    
                
                    
                        /*
                        *  Parse options
                        */
                        
                        let optionsContent = object["options"]
                        let parser = VariantParser(json: optionsContent)
                        let options = parser.parse_options()
                        let new_options_list: List<VariantOption> = List<VariantOption>()
                        
                        for el in options {
                            new_options_list.append(el)
                        }
                        
                        myObject.options = new_options_list
                        
                        /*
                        *  End parse options
                        */
                
                   
                   
                    
                    let currencyJSON = object["currency"]
                    let currencyParser = CurrencyParser(json: currencyJSON)
                    
                    if let currency = currencyParser.parse() {
                        myObject.currency = currency
                    }
                 
                     list.append(myObject)
                    
                    
                }
                
                
            }
            
            
            
            
            
            return list
        }
        
        return []
    }
    
   
    
    func parse_options() -> [VariantOption] {
        
        var list = [VariantOption]()
        
        
        if let myResult = self.result {
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    let myObject = VariantOption()
                    
                
                    myObject.id = object["id"].intValue
                    myObject.value = object["value"].doubleValue
                    myObject.label = object["label"].stringValue
                    myObject.option_type = object["option_type"].stringValue
                    myObject.parent_id = object["parent_id"].intValue
                    myObject.created_at = object["id"].stringValue
                    myObject.updated_at = object["id"].stringValue
                    myObject.parsed_value = object["parsed_value"].stringValue
                    
                    
                    list.append(myObject)
                }
                
                
            }
            
            
            
            
            
            return list
        }
        
        return []
    }
    
   
    
    
}



