//
//  OfferCardCell.swift
//  NearbyUsers
//
//  Created by DT Team  on 8/11/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import UIKit
import Cosmos
import SwiftIcons

class UserCardCell: UICollectionViewCell {

    
    
    //contraints
    @IBOutlet weak var imageContainerConstraintHeight: NSLayoutConstraint!
    @IBOutlet weak var imageConstraintHeight: NSLayoutConstraint!
    @IBOutlet weak var imageConstraintWidth: NSLayoutConstraint!
    
    
    
    @IBOutlet weak var infoConstraintHeight: NSLayoutConstraint!
    
    //view
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var innerView: UIView!
    @IBOutlet weak var name: UILabel!
    @IBOutlet weak var detail: UILabel!
   
    @IBOutlet weak var imageContainer: UIView!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
    
        
    }
    
    func makeAsDefault() {
        
        self.imageContainer.isSkeletonable = false
        self.name.isSkeletonable = false
        self.detail.isSkeletonable = false
        
        self.imageContainer.hideSkeleton()
        self.name.hideSkeleton()
        self.detail.hideSkeleton()
        
    }
    
    func makeAsLoader() {
        
        self.image.isSkeletonable = true
        self.name.isSkeletonable = true
        self.detail.isSkeletonable = true
       
        self.image.showAnimatedGradientSkeleton()
        self.name.showAnimatedGradientSkeleton()
        self.detail.showAnimatedGradientSkeleton()
        
    }
    
    let offline = UIImage.init(icon: .googleMaterialDesign(.radioButtonUnchecked), size: CGSize(width: 18, height: 18), textColor: Colors.lightGreen)
    let online = UIImage.init(icon: .googleMaterialDesign(.checkCircle), size: CGSize(width: 18, height: 18), textColor: Colors.lightGreen)
    
    func setting(style: CardHorizontalStyle?){
        

        self.innerView.backgroundColor = .clear
        
        self.image.contentMode = .scaleAspectFill
        self.image.layer.masksToBounds = false
        
        //setup image size
        self.image.layer.cornerRadius = CGFloat(self.image.frame.height/2)
        self.image.clipsToBounds = true

        self.name.textColor = Colors.primaryColor
        self.name.initBolodFont(size: 13)
        self.name.textAlignment = .center
        self.name.setLeftIcon(image: online)
        
        self.detail.textColor = Colors.white
        self.detail.initDefaultFont(size: 10)
        self.detail.textAlignment = .center
        
        innerView.layer.cornerRadius = 5.0
        innerView.layer.masksToBounds = true
        
        layer.shadowColor = UIColor(red: 0, green: 0, blue: 0, alpha: 0.1).cgColor
        layer.shadowOffset = CGSize(width: 4, height: 4)
        layer.shadowRadius = 30
        layer.shadowOpacity = 1
        layer.masksToBounds = false
        layer.shadowPath = UIBezierPath(roundedRect: bounds, cornerRadius: contentView.layer.cornerRadius).cgPath
        layer.backgroundColor = UIColor.clear.cgColor

    }
    
    
    func setup(object: User?) {
        

        if let object = object {
            
            makeAsDefault()
         
            
            let fullNameArr = object.name.split(separator: " ")
            let firstName:String = String(fullNameArr[0])
            self.name.text = firstName
            self.name.textAlignment = .center
            
            //Commented for UI3.0
            // self.name.text = object.name
//            if object.blocked {
//                self.name.textColor = Colors.gray
//            }else{
//                self.name.textColor = Colors.primaryColor
//            }
            
            self.detail.text = "@\(object.username)"
            
            
            //set image
            if let image = object.images {
                
                let url = URL(string: image.url100_100)
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
                
            }else{
                
                if let img = UIImage(named: "profile_placeholder") {
                    self.image.image = img
                }
            }
            
        }else{
            self.makeAsLoader()
        }
        
    }

}
