//
//  StoreProductCell.swift
//  NearbyStores
//
//  Created by Amine on 7/4/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import Kingfisher

class StoreProductView: UIView {
    
    @IBOutlet weak var descriptionLabelCover: GradientBGView!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var labelDescription: UILabel!
    @IBOutlet weak var title: UILabel!
    @IBOutlet weak var promoTag: EdgeLabel!
    @IBOutlet weak var priceTag: EdgeLabel!
    
    @IBOutlet weak var itemBtn: UIButton!
    
    @IBAction func onPress(_ sender: Any) {
        
    }
    
    
    @IBOutlet weak var container: UIView!
    func settings() {
        
        title.initBolodFont()
        labelDescription.initDefaultFont()
        
        promoTag.initBolodFont()
        promoTag.leftTextInset = 5
        promoTag.rightTextInset = 5
        promoTag.backgroundColor = Colors.primaryColor
        promoTag.textColor = UIColor.white
        promoTag.sizeToFit()
        promoTag.adjustsFontSizeToFitWidth = true
        promoTag.roundCorners(radius: 5)
 
        
        priceTag.initBolodFont()
        priceTag.leftTextInset = 5
        priceTag.rightTextInset = 5
        priceTag.backgroundColor = Colors.primaryColor
        priceTag.textColor = UIColor.white
        priceTag.sizeToFit()
        priceTag.adjustsFontSizeToFitWidth = true
        priceTag.roundCorners(radius: 5)
 
        
        image.roundCorners(radius: 5)
        
        container.translatesAutoresizingMaskIntoConstraints = false
        container.widthAnchor.constraint(equalToConstant: self.frame.width).isActive = true
        
        
    }
    
    func setup(object: Product) {
        
        self.title.text = object.name
        self.labelDescription.text = object.store_name
        
        
        if object.listImages.count > 0 {
            
            if object.listImages[0].url500_500 != ""{
                let url = URL(string: object.listImages[0].url500_500)
                
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
           
        }else{
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
      

        if object.product_type == "price" {
            
            if let currency = object.currency {
                if let pprice = currency.parseCurrencyFormat(price: Float(object.product_value)){
                    promoTag.text = pprice
                    priceTag.text = pprice
                }
            }
           
        }else if object.product_type == "percent" {
            
            promoTag.text = "\(Int(object.product_value))%"
            priceTag.text =  "\(Int(object.product_value))%"
        
        }else{
            promoTag.text = "Promotion".localized
            priceTag.text = "Promotion".localized
        }
        
        promoTag.isHidden = true
        
    }
    
    
    
    
}
