//
//  StoreCell.swift
//  NearbyStores
//
//  Created by Amine on 5/31/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import Cosmos
import Kingfisher

class StoreCell: UICollectionViewCell {
    
    
    //Outlets
    @IBOutlet weak var container_shadow: UIView!
    @IBOutlet weak var container: UIView!
    
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var title: UILabel!
    @IBOutlet weak var address: UILabel!
    @IBOutlet weak var infosContainer: UIView!
    @IBOutlet weak var sale: EdgeLabel!
    @IBOutlet weak var distance: EdgeLabel!
    @IBOutlet weak var ratingContainer: UIView!
    @IBOutlet weak var lastProduct: EdgeLabel!
    @IBOutlet weak var featured: EdgeLabel!
    @IBOutlet weak var highlightedCover: UIView!
    @IBOutlet weak var open_store_badge: EdgeLabel!
    @IBOutlet weak var category_badge: EdgeLabel!
    
    
    
    override var isHighlighted: Bool {
        didSet {
            if isHighlighted{
                highlightedCover.backgroundColor = Colors.white.withAlphaComponent(0.2)
            }else{
                highlightedCover.backgroundColor = UIColor.clear
            }
        }
    }
    
    func setupSettings()  {
        
        // radius & shadowing style
        container_shadow.addShadowView(width:1, height:5, opcaity:0.1, maskToBounds:false, radius:5)
        container.roundedCorners(radius: 20)
          
       
        //distance tag
        distance.leftTextInset = 8
        distance.rightTextInset = 8
        distance.topTextInset = 4
        distance.bottomTextInset = 4
        distance.backgroundColor = Colors.promoTagColor
        distance.initBolodFont()
        distance.sizeToFit()
        distance.roundedCorners()
        
        
        //products tag
        lastProduct.leftTextInset = 10
        lastProduct.rightTextInset = 10
        lastProduct.topTextInset = 5
        lastProduct.bottomTextInset = 5
        lastProduct.backgroundColor = Colors.primaryColor
        lastProduct.initDefaultFont()
     
        
        
        //products tag
        sale.leftTextInset = 12
        sale.rightTextInset = 12
        sale.topTextInset = 8
        sale.bottomTextInset = 8
        sale.backgroundColor = Colors.dealColor
        sale.initDefaultFont()
        sale.roundedCorners()
        
        
        featured.leftTextInset = 12
        featured.rightTextInset = 12
        featured.bottomTextInset = 8
        featured.topTextInset = 8
        featured.backgroundColor = Colors.featuredTagColor
        featured.text = "Featured".localized.uppercased()
        featured.initDefaultFont()
        featured.roundedCorners()
        
        
        self.open_store_badge.layer.cornerRadius = self.open_store_badge.frame.height/3
        self.open_store_badge.layer.masksToBounds = true
        self.open_store_badge.backgroundColor = .orange
        self.open_store_badge.leftTextInset = 8
        self.open_store_badge.rightTextInset = 8
        //text color & font
        self.open_store_badge.textColor = .white
        self.open_store_badge.textAlignment = .center
        self.open_store_badge.initBolodFont(size: 12)
        
        
        //category
        self.category_badge.layer.cornerRadius = self.category_badge.frame.height/3
        self.category_badge.layer.masksToBounds = true
        self.category_badge.backgroundColor = .orange
        self.category_badge.leftTextInset = 8
        self.category_badge.rightTextInset = 8
        
        //text color & font
        self.category_badge.textColor = .white
        self.category_badge.textAlignment = .center
        self.category_badge.initDefaultFont(size: 10)
    
        image.contentMode = .scaleAspectFill
        
        ratingContainer.addSubview(ratingView)
      
        //if it is RTL
        if Utils.isRTL(){
            
            ratingView.translatesAutoresizingMaskIntoConstraints = false
            ratingContainer.addConstraints([
                NSLayoutConstraint(
                    item: ratingView,
                    attribute: .top,
                    relatedBy: NSLayoutConstraint.Relation.equal,
                    toItem: ratingContainer,
                    attribute: .top,
                    multiplier: 1, constant: 0),
                NSLayoutConstraint(
                    item: ratingView,
                    attribute: .bottom,
                    relatedBy: NSLayoutConstraint.Relation.equal,
                    toItem: ratingContainer,
                    attribute: .bottom,
                    multiplier: 1, constant: 0),
                NSLayoutConstraint(
                    item: ratingView,
                    attribute: .right,
                    relatedBy: NSLayoutConstraint.Relation.equal,
                    toItem: ratingContainer,
                    attribute: .right,
                    multiplier: 1, constant: 0),
                ])
        }
        
        
      
        title.initBolodFont()
        address.initDefaultFont()
        

        
        self.featured.text = ""
        self.featured.setIcon(icon: .linearIcons(.pushpin), iconSize: 18, color: .white, bgColor: Colors.featuredTagColor)
        
    
    }
    
    
    func setup_opening_time(store: Store) {
        
        /*
        * OPENING CLOSING TIME TABLE
        */

        if store.opening == 1{
            
            let icon = UIImage.init(icon: .ionicons(.clock), size: CGSize(width: 18, height: 18), textColor: .white)
            self.open_store_badge.text = " \("Open".localized)"
            self.open_store_badge.setLeftIcon(image: icon)
            self.open_store_badge.backgroundColor = .greenSea
            
            self.open_store_badge.isHidden = false
            
        }else if store.opening == -1 {
           
            let icon = UIImage.init(icon: .ionicons(.clock), size: CGSize(width: 18, height: 18), textColor: .white)
            self.open_store_badge.text = " \("Closed".localized)"
            self.open_store_badge.setLeftIcon(image: icon)
            self.open_store_badge.backgroundColor = .orange
            
            self.open_store_badge.isHidden = false
           
        }else{
            
            self.open_store_badge.isHidden = true
           
            
        }
        
    }
    
    
    func setup(object: Store)  {
        
        guard object.id > 0 else {
                   makeAsLoader()
                   return
               }
               
               makeAsDefault()
               
      
        
        self.title.text = object.name
        self.address.text = object.address
        
        
        let formatter = NumberFormatter()
        formatter.usesGroupingSeparator = true
        formatter.numberStyle = .decimal
        formatter.maximumFractionDigits = 1
        // localize to your grouping and decimal separator
        formatter.locale = Locale.current
        
        let number = NSNumber(value: object.votes)
     
        
        if let value = formatter.string(from: number){
             self.ratingView.text = "\(value) (\(object.nbr_votes)) "
        }else{
            self.ratingView.text = "\(object.votes) (\(object.nbr_votes)) "
        }
       
        self.ratingView.rating = 1
        
    
        //set image
        if object.listImages.count > 0 {
            if let first = object.listImages.first {
                
                let url = URL(string: first.url500_500)
              
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
        }else{
            
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        
        self.category_badge.text = object.category_name
        self.category_badge.backgroundColor = Colors.primaryColor
        
        self.lastProduct.isHidden = true
        
        let distance = object.distance.calculeDistance()
        
        Utils.printDebug("\(distance)")
    
        self.distance.text = distance.getCurrent()
     
        if MyLocation.isProvided{
            self.distance.isHidden = false
        }else{
            self.distance.isHidden = true
        }
        
        if object.featured == 1 {
            self.featured.isHidden = false
        }else {
            self.featured.isHidden = true
        }
        
         
        let icon = UIImage.init(icon: .googleMaterialDesign(.place), size: CGSize(width: 18, height: 18), textColor: UIColor.gray)
               
        if Utils.isRTL(){
            self.address.setRightIcon(image: icon)
        }else{
            self.address.setLeftIcon(image: icon)
        }
        

    
        self.setup_opening_time(store: object)
        
    }
    
    
    let ratingView: CosmosView = {
        
        
       
        let cosmosView = CosmosView()
        
        cosmosView.rating = 1
        cosmosView.settings.totalStars = 1
        
        // Change the text
        cosmosView.text = " 0 (0)"
        cosmosView.settings.textColor = .black
        cosmosView.settings.updateOnTouch = false
        
        if let font = UIFont(name: AppConfig.Design.Fonts.bold, size: 12) {
             cosmosView.settings.textFont = font
        }
       
        
        // Called when user finishes changing the rating by lifting the finger from the view.
        // This may be a good place to save the rating in the database or send to the server.
        cosmosView.didFinishTouchingCosmos = { rating in }
        
        // A closure that is called when user changes the rating by touching the view.
        // This can be used to update UI as the rating is being changed by moving a finger.
        cosmosView.didTouchCosmos = { rating in }
        
        
        return cosmosView
    }()
    
    
  
      func makeAsDefault() {
         
        self.image.isSkeletonable = false
        self.title.isSkeletonable = false
        self.address.isSkeletonable = false
          
        self.image.hideSkeleton()
        self.title.hideSkeleton()
        self.address.hideSkeleton()
        
    
        self.ratingContainer.isHidden = false
        self.ratingContainer.isHidden = false
        self.lastProduct.isHidden = false
        self.open_store_badge.isHidden = false
        self.category_badge.isHidden = false
        
      }
      
      
      func makeAsLoader() {
        
        self.image.isSkeletonable = true
        self.title.isSkeletonable = true
        self.address.isSkeletonable = true
              
        self.image.showAnimatedSkeleton()
        self.title.showAnimatedGradientSkeleton()
        self.address.showAnimatedGradientSkeleton()
              
        self.featured.isHidden = true
        self.distance.isHidden = true
                
        self.ratingContainer.isHidden = true
        self.lastProduct.isHidden = true
        self.open_store_badge.isHidden = true
        self.category_badge.isHidden = true
         
          
      }

}
