//
//  ListProductsCell.swift
//  NearbyStores
//
//  Created by Amine on 5/30/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import GoogleMaps
import Cosmos
import RealmSwift
import MapKit


class GeoStoresView: BaseView {
    
    enum Request {
           static let nearby = 0
           static let saved = -1
       }
   
    var mView: GeoMapView? = nil
    
    override func setupViews() {
       
    }
    
    
    override func fetch(request: String) {
    
        //load view
        mView = UINib(nibName: "GeoMapView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! GeoMapView
        self.addSubview(mView!)
        
        
        mView!.translatesAutoresizingMaskIntoConstraints = false

      
                     
        if let v = viewController{
            mView?.viewController = v
        }
      
                               
        // lets set up some constraints for our label
               
        addConstraintsWithFormat(format: "H:|[v0]|", views: mView!)
        addConstraintsWithFormat(format: "V:|[v0]|", views: mView!)

                     
        isFetched = true
        
        mView!.setupViews()
        mView!.fetch(request: request)
        
        
    }
   
    
}
