//
//  ProductCardCell.swift
//  NearbyProducts
//
//  Created by Amine  on 8/11/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import UIKit
import Cosmos
import SkeletonView

class ProductCardCell: UICollectionViewCell {

    
    //contraints
    @IBOutlet weak var imageConstraintHeight: NSLayoutConstraint!
    @IBOutlet weak var infoConstraintHeight: NSLayoutConstraint!
    
    //view
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var name: UILabel!
    @IBOutlet weak var imageContainer: UIView!
    @IBOutlet weak var price: EdgeLabel!
    @IBOutlet weak var sale: EdgeLabel!
    @IBOutlet weak var original_price: EdgeLabel!
    @IBOutlet weak var featured: EdgeLabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
    
        
    }
    
    func makeAsDefault() {
        
        self.image.isSkeletonable = false
        self.name.isSkeletonable = false
      
        self.image.hideSkeleton()
        self.name.hideSkeleton()
       
        
        self.featured.isHidden = false
        self.price.isHidden = false
        self.original_price.isHidden = false
        self.sale.isHidden = false
      
       
    }
    
    
    func makeAsLoader() {
        
        self.image.isSkeletonable = true
        self.name.isSkeletonable = true
      
        self.image.showAnimatedGradientSkeleton()
        self.name.showAnimatedGradientSkeleton()
       
        self.featured.isHidden = true
        self.price.isHidden = true
        self.original_price.isHidden = true
        self.sale.isHidden = true
    
        
    }
    
    func setting(style: CardHorizontalStyle){
        
        self.imageConstraintHeight.constant = CGFloat(style.height!-50-Products_HCards.header_size)
     
        self.image.addRadius()
        self.imageContainer.addShadowView()
        self.name.initDefaultFont(size: 14)
        //self.name.textColor = .black
        
        //price label
        self.price.topTextInset = 10
        self.price.bottomTextInset = 10
        self.price.backgroundColor = .clear
        self.price.initBolodFont(size: 14)
        self.price.textColor = Colors.promoTagColor
        
        
        //discount label
        self.original_price.topTextInset = 10
        self.original_price.bottomTextInset = 10
        self.original_price.backgroundColor = .clear
        self.original_price.initItalicFont(size: 14)
        self.original_price.textColor = .gray
        
        
        //offers tag
        self.sale.leftTextInset = 8
        self.sale.rightTextInset = 8
        self.sale.topTextInset = 4
        self.sale.bottomTextInset = 4
        self.sale.backgroundColor = Colors.promoTagColor
        self.sale.initDefaultFont(size: 14)
        self.sale.textColor = .white
        self.sale.roundCorners()
        
      
    
        self.featured.leftTextInset = 5
        self.featured.rightTextInset = 5
        self.featured.topTextInset = 4
        self.featured.bottomTextInset = 4
        self.featured.backgroundColor = Colors.featuredTagColor
        self.featured.initDefaultFont(size: 14)
        self.featured.textColor = .white
        self.featured.roundCorners()
        self.featured.text = ""
        
        self.featured.setIcon(icon: .linearIcons(.pushpin), iconSize: 18, color: .white, bgColor: Colors.featuredTagColor)
        
        
    }
    
    
    func setup(object: Product?) {
        
        //configure & setup
        if let object = object {
            
            self.makeAsDefault()
            
            self.name.text = object.name
            
            
            if object.listImages.count>0 {
                
                if object.listImages[0].url500_500 != ""{
                    let url = URL(string: object.listImages[0].url500_500)
                    self.image.kf.indicatorType = .activity
                    self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
                }else{
                    if let img = UIImage(named: "default_store_image") {
                        self.image.image = img
                    }
                }
                
                
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
            
            
            if object.featured == 1 {
                self.featured.isHidden = false
            }else {
                self.featured.isHidden = true
            }
            
            _ = object.distance.calculeDistance()
            //self.distance.text = distance.getCurrent(type: AppConfig.distanceUnit)
            
            if object.product_type == "price" {
                
                if let currency = object.currency {
                    
                    if(object.original_value > 0){
                        
                        if let pprice = currency.parseCurrencyFormat(price: Float(object.product_value)){
                            self.price.text = "\(pprice)"
                            self.original_price.isHidden = true
                        }
                        
                        if let pprice = currency.parseCurrencyFormat(price: Float(object.original_value)){
                          
                            let attributeString: NSMutableAttributedString =  NSMutableAttributedString(string: "\(pprice)")
                                attributeString.addAttribute(NSAttributedString.Key.strikethroughStyle, value: 1, range: NSMakeRange(0, attributeString.length))
                        
                            self.original_price.attributedText = attributeString
                            self.original_price.isHidden = false
                            
                            
                            let actual_price = Float(object.product_value)
                            let op = Float(object.original_value)
                            
                           let value =  ((op - actual_price) / (op)) * 100
                            
                            self.sale.isHidden = false
                            self.sale.text = " %@%% OFF".localized.format(arguments: "\(Int(value))")
                            
                        }
                        
                    }else{
                        
                        if let pprice = currency.parseCurrencyFormat(price: Float(object.product_value)){
                             self.price.text = "\(pprice)"
                            self.original_price.isHidden = true
                            self.sale.isHidden = true
                        }
                    }
                  
                }
                
            }else if object.product_type == "percent" {
                //self.detail.text = "\(Int(object.product_value))% - "+object._description
                self.price.text = "\(Int(object.product_value))%"
                self.original_price.isHidden = true
            }else{
               // self.detail.text = "\("Promotion".localized) - "+object._description
                self.price.text = "\("Promotion".localized)"
                self.original_price.isHidden = true
            }
            
            
           
            
        }else{
            
            self.makeAsLoader()
            
        }
        
    }

}
