//
//  File.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/21/20.
//  Copyright © 2020 Amine. All rights reserved.
//

import Foundation




enum CardHorizontalViewTypes {
    case Nearby_Stores, Top_Nearby_Stores, Recent_Stores, Recent_Products, TopProductInCategory1, TopProductInCategory2, TopProductInCategory3, Recent_Offers, Nearby_Offers, Featured_Offers, Best_Seller_Stores,
    TopCategories, FeaturedStores,FeaturedProducts, TopSellerProducts, FeaturedOffers, Sliders, Delievry,Nearby_Users
}


enum CardHorizontalViewSizes {
    static let Small:[Float] = [300,320]
    static let Medium:[Float] = [300,320]
     static let Large:[Float] = [300,320]
     static let Xlarge:[Float] = [300,320]
    static let Xxlarge:[Float] = [300,320]
}


enum CardViewTypes {
    case VerticalMode ,HorizontalMode
}

class CardStyle {
    let mode: CardViewTypes?
    init(mode: CardViewTypes) {
        self.mode = mode
    }
}

class CardHorizontalStyle: CardStyle {
    
    var Title: String?
    var width: Float?
    var height: Float?
    var enabled: Bool?
    
    var type: CardHorizontalViewTypes?
    
    init(size: [Float], type: CardHorizontalViewTypes) {
        super.init(mode: .HorizontalMode)
        self.width = size[0]
        self.height = size[1]
        self.type = type
    }
    
    init(size: [Float], enabled: Bool) {
        super.init(mode: .HorizontalMode)
        self.width = size[0]
        self.height = size[1]
        self.enabled = enabled
    }
    
    init(width: Float, height: Float, enabled: Bool) {
        super.init(mode: .HorizontalMode)
        self.width = width
        self.height = height
        self.enabled = enabled
    }
    
    init(width: Float, height: Float, enabled: Bool, type: CardHorizontalViewTypes) {
        super.init(mode: .VerticalMode)
        self.width = width
        self.height = height
        self.enabled = enabled
        self.type = type
    }
    
    init(width: Float, height: Float, type: CardHorizontalViewTypes,title:String) {
        super.init(mode: .VerticalMode)
        self.width = width.adaptScreen()
        self.height = height.adaptScreen()
        self.Title = title
        self.type = type
    }
    
    init(width: Float, height: Float, type: CardHorizontalViewTypes) {
        super.init(mode: .VerticalMode)
        self.width = width.adaptScreen()
        self.height = height.adaptScreen()
        self.type = type
    }
    
    init(allSize: Float, type: CardHorizontalViewTypes) {
        super.init(mode: .VerticalMode)
        self.width = allSize
        self.height = allSize
        self.type = type
    }
    
    
}
