import UIKit
import Kingfisher

class ProductImageCarousel: UIScrollView {
    var ll: UIStackView!
    var views: [UIView] = []
    var numbers = 0
    
    func setup() {
        
        ll = UIStackView()
        ll.axis = .horizontal
        ll.spacing = 10
        ll.layoutMargins = UIEdgeInsets(top: 10, left: 10, bottom: 0, right: 10)
        ll.isLayoutMarginsRelativeArrangement = true
        
        addSubview(ll)
        
        addConstraintsWithFormat(format: "H:|[v0]|", views: ll)
        addConstraintsWithFormat(format: "V:|[v0]|", views: ll)

    }
    
    func addImage(url: String, isActive: Bool) -> UIImageView {
        let fp = UIView()
        fp.layer.borderWidth = 2
        fp.layer.borderColor = UIColor.red.cgColor
        fp.layer.cornerRadius = 5
        fp.layer.masksToBounds = true
        fp.alpha = isActive ? 1.0 : 0.7
        
        let img = UIImageView()
        img.image = UIImage(named: "def_logo")
        img.contentMode = .center
        img.translatesAutoresizingMaskIntoConstraints = false
        
        fp.addSubview(img)
        ll.addArrangedSubview(fp)
        
        let imageUrl = URL(string: url)
        img.kf.setImage(with: imageUrl, placeholder: UIImage(named: "def_logo"))
        
        views.append(fp)
        numbers += 1
        
        return img
    }
    
    func makeAllAlpha() {
        for view in views {
            view.alpha = 0.7
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
}
