//
//  ProductCell.swift
//  NearbyStores
//
//  Created by Amine on 6/7/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import SkeletonView

class ProductCell: UICollectionViewCell {

    @IBOutlet weak var container_shadow: UIView!
    @IBOutlet weak var container: UIView!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var featured: EdgeLabel!
    @IBOutlet weak var product_value: EdgeLabel!
    @IBOutlet weak var original_price: EdgeLabel!
    @IBOutlet weak var store_name: UILabel!
    @IBOutlet weak var title: UILabel!
    
    @IBOutlet weak var deal_label: EdgeLabel!
    
    func setupSettings()  {
        
        
         // radius & shadowing style
        container_shadow.addShadowView(width:1, height:5, opcaity:0.1, maskToBounds:false, radius:5)
        container.roundedCorners(radius: 20)
          
        
        //products tag
        product_value.leftTextInset = 8
        product_value.rightTextInset = 8
        product_value.topTextInset = 4
        product_value.bottomTextInset = 4
        product_value.backgroundColor = .white
        product_value.textColor = Colors.promoTagColor
        product_value.initBolodFont()
        product_value.sizeToFit()
    
        original_price.initBolodFont()

        
        featured.leftTextInset = 12
        featured.rightTextInset = 12
        featured.bottomTextInset = 8
        featured.topTextInset = 8
        featured.backgroundColor = Colors.featuredTagColor
        featured.text = "Featured".localized.uppercased()
        featured.initDefaultFont()
        featured.roundedCorners()
        
        
        //offers tag
        self.deal_label.leftTextInset = 8
        self.deal_label.rightTextInset = 8
        self.deal_label.topTextInset = 4
        self.deal_label.bottomTextInset = 4
        self.deal_label.backgroundColor = Colors.promoTagColor
        self.deal_label.initDefaultFont(size: 14)
        self.deal_label.textColor = .white
        self.deal_label.roundCorners()
        
        
        image.contentMode = .scaleAspectFill
        
        title.initBolodFont(size: 16)
        store_name.initDefaultFont(size: 14)
        
        
        self.featured.text = ""
        self.featured.setIcon(icon: .linearIcons(.pushpin), iconSize: 18, color: .white, bgColor: Colors.featuredTagColor)
    
        
    }
    
    func setup(object: Product)  {
        
        
        guard object.id > 0 else {
            makeAsLoader()
            return
        }
        
        makeAsDefault()
        
        
        self.title.text = object.name
        self.store_name.text = object.store_name
        
       
        
        let icon = UIImage.init(icon: .googleMaterialDesign(.place), size: CGSize(width: 24, height: 24), textColor: UIColor.gray)
        
        if Utils.isRTL(){
            self.store_name.setRightIcon(image: icon)
        }else{
           self.store_name.setLeftIcon(image: icon)
        }
        
        
        if object.listImages.count>0 {
            
            if object.listImages[0].url500_500 != ""{
                let url = URL(string: object.listImages[0].url500_500)
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
            
            
        }else{
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        
        if object.featured == 1 {
            self.featured.isHidden = false
        }else {
            self.featured.isHidden = true
        }
        
        
        if object.product_type == "price" {
            
            if let currency = object.currency {
                
                if(object.original_value > 0){
                    
                    if let pprice = currency.parseCurrencyFormat(price: Float(object.product_value)){
                        self.product_value.text = "\(pprice)"
                        self.original_price.isHidden = true
                    }
                    
                    if let pprice = currency.parseCurrencyFormat(price: Float(object.original_value)){
                      
                        let attributeString: NSMutableAttributedString =  NSMutableAttributedString(string: "\(pprice)")
                            attributeString.addAttribute(NSAttributedString.Key.strikethroughStyle, value: 1, range: NSMakeRange(0, attributeString.length))
                    
                        self.original_price.attributedText = attributeString
                        self.original_price.isHidden = false
                        
                        
                        let actual_price = Float(object.product_value)
                        let op = Float(object.original_value)
                        
                       let value =  ((op - actual_price) / (op)) * 100
                        
                        self.deal_label.isHidden = false
                        self.deal_label.text = " %@%% OFF".localized.format(arguments: "\(Int(value))")
                        
                    }
                    
                }else{
                    
                    if let pprice = currency.parseCurrencyFormat(price: Float(object.product_value)){
                         self.product_value.text = "\(pprice)"
                        self.original_price.isHidden = true
                        self.deal_label.isHidden = true
                    }
                }
              
            }
            
        }else if object.product_type == "percent" {
            //self.detail.text = "\(Int(object.product_value))% - "+object._description
            self.product_value.text = "\(Int(object.product_value))%"
            self.original_price.isHidden = true
        }else{
           // self.detail.text = "\("Promotion".localized) - "+object._description
            self.product_value.text = "\("Promotion".localized)"
            self.original_price.isHidden = true
        }
        
    
       
        
    }
    
    

    
    
      func isLessThan1Second(components: DateComponents) -> Bool {
             
             if components.year!<0{
                 return true
             }
             
             if components.month!<0{
                 return true
             }
             
             if components.day!<0{
                 return true
             }
             
             if components.hour!<0{
                 return true
             }
             
             if components.minute!<0{
                 return true
             }
             
             if components.second!<0{
                 return true
             }
             
             guard components.year! >= 0 else { return false }
             guard components.month! >= 0 else { return false }
             guard components.day! >= 0 else { return false }
             guard components.hour! >= 0  else { return false }
             guard components.minute! >= 0  else { return false }
             guard components.second! < 0  else { return false }
             
            
             return true
         }
      
    
    
       func getDiffTime(date_end_UTC: String) -> MyTime?{
           
            let dateRangeStart = Date()
           
           if let dateEnd = DateUtils.convertToDate(dateUTC: date_end_UTC) {
               
                let components = Calendar.current.dateComponents([.year, .month, .day, .hour, .minute, .second], from: dateRangeStart, to: dateEnd)
               
               var time = MyTime()
               time.days = components.day!
               time.hours = components.hour!
               time.minutes = components.minute!
               time.seconds = components.second!
               time.dateComponents = components
               
               return time
               
           }
           
           return nil
       }
       
    
    
      func makeAsDefault() {
         
          self.image.isSkeletonable = false
          self.title.isSkeletonable = false
          self.store_name.isSkeletonable = false
          
          self.image.hideSkeleton()
          self.title.hideSkeleton()
          self.store_name.hideSkeleton()

          
          self.featured.isHidden = false
          self.product_value.isHidden = false
          self.store_name.isHidden = false
          self.original_price.isHidden = false
         
      }
      
      
      func makeAsLoader() {
          
    
          self.image.isSkeletonable = true
          self.title.isSkeletonable = true
          self.store_name.isSkeletonable = true
          
          self.image.showAnimatedSkeleton()
          self.title.showAnimatedGradientSkeleton()
          self.store_name.showAnimatedGradientSkeleton()
          
          self.featured.isHidden = true
          self.product_value.isHidden = true
          self.deal_label.isHidden = true
          self.featured.isHidden = true
          self.store_name.isHidden = true
          self.original_price.isHidden = true
        
          
      }
    
}










