//
//  FilterView.swift
//  NearbyCompanies
//
//  Created by Amine on 4/1/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import UIKit
import SwiftIcons

protocol FilterViewListDelegate {
    func onJobListFilterDatePressed()
    func onJobListFilterDistancePressed()
}

class FilterViewList: UIView {

    
    var delegate: FilterViewListDelegate? = nil
    var filter_value: Int = 0
    
    
    @IBOutlet weak var by_date_btn: UIButton!
    @IBOutlet weak var by_distance_btn: UIButton!
    
    @IBAction func onDistance(_ sender: Any) {
        if let del = self.delegate{
            if self.filter_value == 0{
                
             
                by_date_btn.setTitleColor(.black, for: .normal)
                by_distance_btn.setTitleColor(.white, for: .normal)
                
                by_date_btn.tintColor = Colors.primaryColor
                by_distance_btn.tintColor = .white
                
                by_date_btn.setTitleColor(Colors.primaryColor, for: .normal)
                by_distance_btn.setTitleColor(.white, for: .normal)
                
                
                by_date_btn.backgroundColor = Colors.primaryColor.withAlphaComponent(0.3)
                by_distance_btn.backgroundColor = Colors.primaryColor
                               
                self.filter_value = 1
                
                del.onJobListFilterDistancePressed()
                
                let animation = UIAnimation(view: self.by_distance_btn)
                animation.zoomIn(duration: 0.2)
            }
        }
    }
    
    @IBAction func onDate(_ sender: Any) {
        if let del = self.delegate{
            if self.filter_value == 1{
                
                
                by_date_btn.setTitleColor(.white, for: .normal)
                by_distance_btn.setTitleColor(.black, for: .normal)
                
                by_date_btn.tintColor = .white
                by_distance_btn.tintColor = Colors.primaryColor
                
                by_date_btn.setTitleColor(.white, for: .normal)
                by_distance_btn.setTitleColor(Colors.primaryColor, for: .normal)
                
                
                by_date_btn.backgroundColor = Colors.primaryColor
                by_distance_btn.backgroundColor = Colors.primaryColor.withAlphaComponent(0.3)
               
                self.filter_value = 0
                
                del.onJobListFilterDatePressed()
                
                
                let animation = UIAnimation(view: self.by_date_btn)
                animation.zoomIn()
                               
                
            }
        }
    }
    
    
    func initViews() {
        
        self.backgroundColor = .white
        
        
        by_date_btn.setTitle("Recent".localized, for: .normal)
        by_distance_btn.setTitle("Nearby".localized, for: .normal)
        
        by_date_btn.imageEdgeInsets  = UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 10);
        by_distance_btn.imageEdgeInsets  = UIEdgeInsets(top: 0, left: 0, bottom: 0, right: 10);
        
        
        by_date_btn.backgroundColor = Colors.primaryColor
        by_distance_btn.backgroundColor = Colors.primaryColor.withAlphaComponent(0.3)
        
        
        by_date_btn.tintColor = .white
        by_distance_btn.tintColor = Colors.primaryColor
                        
        by_date_btn.setTitleColor(.white, for: .normal)
        by_distance_btn.setTitleColor(Colors.primaryColor, for: .normal)
                       
       
        
        self.filter_value = 0
        by_date_btn.initDefaultFont()
        by_distance_btn.initDefaultFont()
        
        
    }
    
}
