//
//  ProductDetailViewController.swift
//  NearbyStores
//
//  Created by Amine on 7/10/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import Atributika
import ImageSlideshow
import AssistantKit
import SwiftWebVC
import SwiftEventBus
import Firebase
import RealmSwift


class ProductDetailViewController: MyUIViewController, EmptyLayoutDelegate,ErrorLayoutDelegate, ProductLoaderDelegate, UIScrollViewDelegate, UITextViewDelegate, QtySelectorDelegate, StoreLoaderDelegate, OptionsDelegate, V_Group_Update_Delegate, Products_HCards_Delegate {

    
    //Declare User For Current Session
    var myUserSession: User? = nil
    let slideShow = ImageSlideshow()
    
    
    @IBOutlet weak var categoriesStackview: UIStackView!
    //adview
    @IBOutlet weak var adSubContainer: UIView!
    @IBOutlet weak var adContainer: UIView!
    @IBOutlet weak var navigationBar: UINavigationBar!
    @IBOutlet weak var navigationBarItem: UINavigationItem!
    @IBOutlet weak var productTitle: EdgeLabel!
    @IBOutlet weak var imageView: UIImageView!
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet weak var stackview: UIStackView!
    @IBOutlet weak var stackViewRightConstraint: NSLayoutConstraint!
    @IBOutlet weak var stackViewLeftConstraint: NSLayoutConstraint!
    @IBOutlet weak var relatedItemsContainer: UIView!
    @IBOutlet weak var variantSelectorMainContainer: UIStackView!
    @IBOutlet weak var variantelectorStackView: UIStackView!
    @IBOutlet weak var descriptionTextView: UITextView!
    @IBOutlet weak var product_dates_container: UIStackView!
    @IBOutlet weak var product_dates: EdgeLabel!
    @IBOutlet weak var favBottomButton: UIButton!
    @IBOutlet weak var imageHeightConstraint: NSLayoutConstraint!
   
    
    @IBAction func favouriteAction(_ sender: Any) {
        
        if !Session.isLogged(){
            self.startLoginVC()
            return
        }
        
        if let product = Product.findById(id: product_id!), product.saved == false {
            let icon = UIImage(named: "bookmark-filled"); //unsave icon
            favBottomButton.setBackgroundImage(icon, for: .normal)
            saveAction()
        }else{
            let icon = UIImage(named: "bookmark"); //unsave icon
            favBottomButton.setBackgroundImage(icon, for: .normal)
            unsaveAction()
        }
        
    }
    
    func setupSize()  {
        if(Device.isPad){
            if Device.screen == .inches_9_7{
                let width = self.view.frame.width/1.5
                let finalSize = self.view.frame.width-width
                self.stackViewLeftConstraint.constant = finalSize/2
                self.stackViewRightConstraint.constant = finalSize/2
            }else{
                let width = self.view.frame.width/1.3
                let finalSize = self.view.frame.width-width
                self.stackViewLeftConstraint.constant = finalSize/2
                self.stackViewRightConstraint.constant = finalSize/2
            }
        }
    }
    
    @IBOutlet weak var imageContainer: UIView!
    @IBOutlet weak var descriptionContainer: UIView! //view store
    @IBOutlet weak var descriptionSubContainer: UIView! //subview store
    @IBOutlet weak var productDetailLabel: UILabel!
    @IBOutlet weak var productPrice: EdgeLabel!
    @IBOutlet weak var original_price_label: EdgeLabel!
    @IBOutlet weak var stock_label: EdgeLabel!
    @IBOutlet weak var promo_container: UIView!
    @IBOutlet weak var featured: EdgeLabel!
    @IBOutlet weak var storeAddressSubContainer: UIView!
    @IBOutlet weak var storeAddress: UILabel!
    @IBOutlet weak var countDownSubContainer: UIView!
    @IBOutlet weak var countDownContainer: UIView!
    
    @IBAction func onStoreNameClicked(_ sender: Any) {
        
        if let id = product_id, let product = Product.findById(id: id){
            let sb = UIStoryboard(name: "StoreDetail", bundle: nil)
            if sb.instantiateInitialViewController() != nil {
                
                let ms: StoreDetailViewController = sb.instantiateViewController(withIdentifier: "storedetailVC") as! StoreDetailViewController
                ms.storeId = product.store_id
                
                self.present(ms, animated: true)
            }
        }
    }
    

    @IBOutlet weak var order_button: UIButton!
    @IBAction func order_now_action(_ sender: Any) {
        
        if(!Session.isLogged()){
            startLoginVC()
            return
        }
      
        guard let id = product_id, let product = Product.findById(id: id) else {
            return
        }
       
        
        if product.store_order_enabled == 1 && product.store_order_based_on_op == 0  {
            
            if let store = Store.findById(id: product.store_id), store.opening == -1{
                self.showAlertError(title: "Alert!".localized, content: ["err" : "This store is closed".localized], msgBnt: "OK".localized)
                return
            }
        
        }
       
        
        if product.stock == 0{
           
            self.showAlertError(title: "Stock".localized, content: ["err" : "The product out of stock".localized], msgBnt: "OK".localized)
            return
            
        }
        
        if((product.stock > 0 || product.stock == -1) && product.variants.count > 0){
            start_vs_CV(item_id: product.id)
            return
        }
        
        
        //show dialog product to pick quantity$
        self.showOrderDialog(product: product)
        
    }
    
    
    func saveAction() {
        
        if let user = Session.getInstance()?.user, let product = Product.findById(id: product_id!){
        
            let realm = try! Realm()
            realm.beginWrite()
            product.saved = true
            try! realm.commitWrite()
            
            let parameters = [
                "user_id": String(user.id),
                "product_id": String(product.id),
            ]
            
            let api = SimpleRequestApi()
            api.run(url: Constances.Api.API_SAVE_PRODUCT_BOOKMARK, parameters: parameters) { (parser) in
                if parser?.success==1{
                    let realm = try! Realm()
                    realm.beginWrite()
                    product.saved = true
                    realm.add(product, update: .all)
                    try! realm.commitWrite()
                }
            }
            
        }
       
    }
    
    
    func unsaveAction() {
        
        if let user = Session.getInstance()?.user, let product = Product.findById(id: product_id!){
        
            let realm = try! Realm()
            realm.beginWrite()
            product.saved = false
            try! realm.commitWrite()
            
            let parameters = [
                "user_id": String(user.id),
                "product_id": String(product.id),
            ]
            
            let api = SimpleRequestApi()
            api.run(url: Constances.Api.API_REMOVE_PRODUCT_BOOKMARK, parameters: parameters) { (parser) in
                if parser?.success==1{
                    let realm = try! Realm()
                    realm.beginWrite()
                    product.saved = false
                    realm.add(product, update: .all)
                    try! realm.commitWrite()
                }
            }
            
        }
       
    }
    
    func showOrderDialog(product: Product){
       
        if product.stock >= 1 || product.stock == -1{
            
            let view = qtySelector.show(item: product, amount: Double(product.product_value))
            
            view.cancel_btn.setTitle("Add to cart", for: .normal)
            view.confirm_btn.setTitle("Checkout".localized, for: .normal)
            
            qtySelector.delegate = self
            
        }else{
            
            
            let order_product = OrderProduct()
            order_product.item = product
            order_product.amount = Double(product.product_value)
            order_product.qty = 1
            
            if !Cart.hasStore(item0: order_product){
                self.showAlertError(title: "Cart".localized, content: ["err":"couldn't add an item from the different store".localized], msgBnt: "OK".localized)
                return
            }
            
            self.startCartController(product: order_product)
    
        }
        
    }
    
    
    func onQtySelectorRightPressed(qty: Double) {
        
         if let id = product_id, let product = Product.findById(id: id){
            
            var order_product = OrderProduct()
            order_product.item = product
            order_product.amount = Double(product.product_value)
            order_product.qty = Int(qty)
             
             if variant_selection_result.count > 0{
             
                 var final_amount: Double = Double(product.product_value)
                 for r in variant_selection_result{
                     final_amount = final_amount + r.calculated
                 }
                 
                 order_product.variants = variant_selection_result.toRealmList()
                 order_product.amount = Double(final_amount)
             }
           
            if !Cart.hasStore(item0: order_product){
                self.showAlertError(title: "Cart".localized, content: ["err":"couldn't add an item from the different store".localized], msgBnt: "OK".localized)
                return
            }
           
            self.startCartController(product: order_product)
    
        }
     }
     
     func onQtySelectorLeftPressed(qty: Double) {
       
        
        if let id = product_id, let product = Product.findById(id: id){
           
            let order_product = OrderProduct()
           order_product.item = product
           order_product.amount = Double(product.product_value)
           order_product.qty = Int(qty)
            
            
            if !Cart.hasStore(item0: order_product){
                self.showAlertError(title: "Cart".localized, content: ["err":"couldn't add an item from the different store".localized], msgBnt: "OK".localized)
                return
            }
            
            if variant_selection_result.count > 0{
            
                var final_amount: Double = Double(product.product_value)
                for r in variant_selection_result{
                    final_amount = final_amount + r.calculated
                }
                
                order_product.variants = variant_selection_result.toRealmList()
                order_product.amount = Double(final_amount)
            }
          
            let cart = Cart.openCart(items: [order_product])
            cart.save()
            
            SwiftEventBus.post("update_cart_badge")
       }
        
     }
    
    
    lazy var qtySelector: QtySelectorView = {
          let launcher = QtySelectorView()
         // launcher.mainController = self
          return launcher
      }()
      
      
    
    private var lastContentOffset: CGFloat = 0
    
      func scrollViewDidScroll(_ scrollView: UIScrollView) {
       
          
          if scrollView.contentOffset.y > -100{
              
              navigationBar.isTranslucent = false
              navigationBarItem.titleView?.isHidden = false
             
              UIView.animate(withDuration: 0.2) {
                  self.navigationBar.layoutIfNeeded()
              }
           
              
          }else{
              
              //make it transeparent
              navigationBar.isTranslucent = true
              navigationBarItem.titleView?.isHidden = true

              UIView.animate(withDuration: 0.2) {
                  self.navigationBar.layoutIfNeeded()
              }

            
            
          }
        
        
        
        update_icon_template_scrolling()
         
          // update the new position acquired
          self.lastContentOffset = scrollView.contentOffset.y
      }
    
    func update_icon_template_scrolling(){

        if scrollView.contentOffset.y > -100{
          
          //make white
          for bu in navigationBarItem.rightBarButtonItems!{
              bu.tintColor = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
          }
          
          for bu in navigationBarItem.leftBarButtonItems!{
              bu.tintColor = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
          }
            
        }else{
          
        
          //make white
          for bu in navigationBarItem.rightBarButtonItems!{
              bu.tintColor = AppDesignUtils.defaultModeColor(dark: Colors.primaryColor, light: .white)
          }
          
          for bu in navigationBarItem.leftBarButtonItems!{
              bu.tintColor = AppDesignUtils.defaultModeColor(dark: Colors.primaryColor, light: .white)
          }
          
        }
        
    }
    
    func setupViews() {
        
        
        scrollView.delegate = self
        
        self.view.backgroundColor = Colors.highlightedGray
        
        self.stackview.distribution = .fill
        
        scrollView.parallaxHeader.view = self.imageContainer
        scrollView.parallaxHeader.height = self.imageView.frame.height;
        scrollView.parallaxHeader.mode = .fill;
        scrollView.parallaxHeader.minimumHeight = 0;
        
    
        //products tag
        productPrice.backgroundColor = .clear
        productPrice.textColor = Colors.promoTagColor
        productPrice.initBolodFont(size: 20)
        productPrice.textAlignment = .right

        //distance
        original_price_label.initDefaultFont()
        original_price_label.textColor = .gray
        original_price_label.textAlignment = .right
        
        
        //title
        productTitle.textColor = Colors.black
        productTitle.initBolodFont(size: 20)
        
        //stock
        stock_label.initBolodFont()
        
        promo_container.roundCorners(radius: 10)
        promo_container.addShadowView()
        
        //product dates
        product_dates.leftTextInset = 15
        product_dates.rightTextInset = 15
        product_dates.topTextInset = 10
        product_dates.bottomTextInset = 10
        
        
        
        featured.leftTextInset = 15
        featured.rightTextInset = 15
        featured.bottomTextInset = 10
        featured.topTextInset = 10
        featured.backgroundColor = Colors.featuredTagColor
        featured.isHidden = true
        featured.initItalicFont()
        
        
        product_dates.initItalicFont()
        storeAddress.initDefaultFont()
        
        
        self.descriptionSubContainer.layer.cornerRadius = 5/UIScreen.main.nativeScale
        self.descriptionSubContainer.layer.masksToBounds = true
        
        
        self.storeAddressSubContainer.layer.cornerRadius = 5/UIScreen.main.nativeScale
        self.storeAddressSubContainer.layer.masksToBounds = true
        
        
        self.slideShow.translatesAutoresizingMaskIntoConstraints = false
        
        var constraints = [NSLayoutConstraint]()
        
        constraints.append(NSLayoutConstraint(
            item: self.slideShow,
            attribute: NSLayoutConstraint.Attribute.right,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self.imageView,
            attribute: NSLayoutConstraint.Attribute.right,
            multiplier: 1, constant: 0)
        )
        
        constraints.append(NSLayoutConstraint(
            item: self.slideShow,
            attribute: NSLayoutConstraint.Attribute.top,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self.imageView,
            attribute: NSLayoutConstraint.Attribute.top,
            multiplier: 1, constant: 0)
        )
        
        constraints.append(NSLayoutConstraint(
            item: self.slideShow,
            attribute: NSLayoutConstraint.Attribute.bottom,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self.imageView,
            attribute: NSLayoutConstraint.Attribute.bottom,
            multiplier: 1, constant: 0)
        )
        
        constraints.append(NSLayoutConstraint(
            item: self.slideShow,
            attribute: NSLayoutConstraint.Attribute.left,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self.imageView,
            attribute: NSLayoutConstraint.Attribute.left,
            multiplier: 1, constant: 0)
        )
        
        
        self.imageView.addSubview(slideShow)
        self.imageView.addConstraints(constraints)
        //self.imageView.layoutIfNeeded()
        //self.slideShow.isHidden = true
        
        self.slideShow.pageIndicator = nil
        self.slideShow.contentScaleMode = .scaleAspectFill
        
        let gestureRecognizerImageView = UITapGestureRecognizer(target: self, action: #selector(didTapOnImage))
        self.imageContainer.addGestureRecognizer(gestureRecognizerImageView)
        
    
        //localization
    
        self.productDetailLabel.text = "Product Detail".localized
        
        self.featured.initDefaultFont()
        self.featured.text = "Featured".localized.uppercased()
        self.productDetailLabel.initBolodFont()
        
        
      
        
        
    }
    
    @objc func didTapOnImage() {
        if #available(iOS 13.0, *){
            self.slideShow.presentFullScreenControllerForIos13(from: self)
        }else{
            self.slideShow.presentFullScreenController(from: self)
        }
    }
  

    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        self.imageHeightConstraint.constant = view.frame.height/2
        self.view.layoutIfNeeded()
        
        setupSize()
        
        if let session = Session.getInstance(), let user = session.user {
            myUserSession = user
        }
        
        self.view.backgroundColor = Colors.bg_gray_100
        
    
        self.navigationBar.isTranslucent = false
        self.navigationBar.setBackgroundImage(UIImage(), for: UIBarMetrics.default)
        self.navigationBar.shadowImage = UIImage()
        self.navigationBar.tintColor = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
              
        
       
       
        setupNavBarTitles(title: "Product detail")
        setupNavBarButtons()
        setupViews()
        
        
        if let id = product_id, let _ = Product.findById(id: id){
            self.setupProductDetail()
        }else{
            load()
        }
        
      
        
    }
    

    override func viewWillDisappear(_ animated: Bool) {
        ProductDetailViewController.isAppear = false
    
        if let d = countDownView{
            d.stopTimer()
        }
    }
    
    func setupNavBarButtons() {
        
        let color = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
        
        //arrow back icon
        var arrowImage: UIImage? = nil
        if Utils.isRTL(){
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowForward), size: CGSize(width: 30, height: 30), textColor: color)
        }else{
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowBack), size: CGSize(width: 30, height: 30), textColor: color)
        }
        
        
        let customBarButtonItem = UIBarButtonItem(image: arrowImage!, style: .plain, target: self, action: #selector(onBackHandler))
        customBarButtonItem.setIcon(icon: .ionicons(.iosArrowBack), iconSize: 25, color: color)
        
        
        navigationBarItem.leftBarButtonItems = []
        navigationBarItem.rightBarButtonItems = []
        navigationBarItem.leftBarButtonItems?.append(customBarButtonItem)
       
        //more options icon
        let menuImage = UIImage.init(icon: .ionicons(.androidMoreVertical), size: CGSize(width: 30, height: 30), textColor: Colors.darkColor)
        let moreBarButtonItem = UIBarButtonItem(image: menuImage, style: .plain, target: self, action: #selector(handleMore))
        moreBarButtonItem.setIcon(icon: .ionicons(.iosArrowBack), iconSize: 25, color: color)
        navigationBarItem.rightBarButtonItems?.append(moreBarButtonItem)
        
    }
    
    
    
    lazy var optionsLauncher: OptionsLauncher = {
        let launcher = OptionsLauncher()
        launcher.delegate = self
        return launcher
    }()
    
    
    @objc func handleMore() {
        
        optionsLauncher.clear()
        
        
    
        optionsLauncher.addBottomMenuItem(option: Option(
            id: 1114,
            name: "Share".localized,
            image: optionsLauncher.createIcon(.googleMaterialDesign(.share)),
            object: []
        ))
        
       
        optionsLauncher.addBottomMenuItem(option: Option(
            id: 1111,
            name: "Report".localized,
            image: optionsLauncher.createIcon(.ionicons(.androidWarning)),
            object: []
        ))
        
        
        optionsLauncher.load()
        optionsLauncher.showOptions()
        
    }
    
    func onOptionItemPressed(option: Option) {
        
        if option.id == 1111{
            
            guard Session.isLogged() else {
                self.startLoginVC()
                return
            }
            
            guard let sess = Session.getInstance(), let user = sess.user else {
                return
            }
            
            guard let id = self.product_id, let product = Product.findById(id: id) else {
                return
            }
            
            let reporto  = ReportObject(
                title: "Reported Product: "+product.name,
                link: " ("+AppConfig.Api.base_url+"/dashboard/product/all_products?id=/\(product.id)) \(product.name)",
                owner_user_id: product.user_id,
                reported_by_user_id: user.id
            )
            
            OCReportController.startVC(controller: self,ro: reporto)
        }else if option.id == 1114{
            onSharehHandle()
        }
       
    }
    
  
    
    @objc func onBackHandler()  {
        self.dismiss(animated: true)
    }
    
    
    @objc func onSharehHandle() {
        
        if let id = product_id, let product = Product.findById(id: id) {
            
            let text = "%@ - Only on %@ \n %@".localized.format(arguments: product.name,AppConfig.APP_NAME,product.link)
            
            //%@ - Only on %@ \n %@
            
            let textShare = [ text ]
            let activityViewController = UIActivityViewController(activityItems: textShare , applicationActivities: nil)
            activityViewController.popoverPresentationController?.sourceView = self.view
            self.present(activityViewController, animated: true, completion: nil)
            
        }
        
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        
       ProductDetailViewController.isAppear = true
    
    }
    
    
    static var isAppear = false
    

    
    let topBarTitle: EdgeLabel = {
        
        let titleLabel = EdgeLabel()
        
        titleLabel.text = ""
        titleLabel.textColor = UIColor.white
        titleLabel.font = UIFont.systemFont(ofSize: 20)
        
        return titleLabel
        
    }()
    
    func setupNavBarTitles(title: String) {
        
        
        let rect = CGRect(x: 0, y: 0, width: view.frame.width - 32, height: view.frame.height)
        topBarTitle.frame = rect
        topBarTitle.textColor = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
              
        topBarTitle.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 17)
        topBarTitle.leftTextInset = 5
        
        
        topBarTitle.text = title
        
        navigationBarItem.titleView = topBarTitle
        
    }
    
    
    func setupProductDetail()  {
        
        if let id = product_id, let product = Product.findById(id: id){
            
            self.productDetailLabel.numberOfLines = 0
            self.productDetailLabel.text = product.name
            
            Utils.printDebug("\(product)")

            let end_at = DateUtils._UTC(date: product.date_end, fromFormat: DateFomats.defaultFormatTimeUTC, toFormat:  DateFomats.defaultFormatDate)
            product_dates.text = " \("End at".localized) "+end_at

            let date_icon = UIImage.init(icon: .linearIcons(.calendarFull), size: CGSize(width: 24, height: 24), textColor: Colors.primaryColor)
            
            product_dates.textColor = Colors.primaryColor
            product_dates.setLeftIcon(image: date_icon)
            
            
            
            if product.featured == 1 {
                //self.featured.isHidden = false
            }else{
                //self.featured.isHidden = true
            }
            
    
        
           
            //setup imageview

                    var imagesInputs:[InputSource] = []
                      if product.listImages.count > 0 {
                          
                          
                       
                          
                          for index in 0...product.listImages.count-1{
                              let url = product.listImages[index].url500_500
                              if let k = KingfisherSource(urlString: url){
                                   imagesInputs.append(k)
                              }
                            
                          }
                          
                        
                          
                          self.slideShow.setImageInputs(imagesInputs)
                          
                          
                          if let first = product.listImages.first {
                              
                              let url = URL(string: first.url500_500)
                              self.imageView.kf.indicatorType = .activity
                              
                     
                              self.imageView.kf.setImage(with: url) { result in
                                 switch result {
                                 case .success(let value):
                                     print("Image: \(value.image). Got from: \(value.cacheType)")
                                     
                                      let w =  value.image.size.width
                                      var h = value.image.size.height
                                     
                                     if(h < self.view.frame.height / 2){
                                         h = self.view.frame.height / 2
                                     }
                                      
                                      let ratio = CGFloat(w/h)
                                      let newHeight = self.view.frame.width / ratio
                                      self.imageHeightConstraint.constant = newHeight
                                   
                                      
                                      self.scrollView.parallaxHeader.view = self.imageContainer
                                      self.scrollView.parallaxHeader.height = newHeight
                                      self.scrollView.parallaxHeader.mode = .center;
                                      self.scrollView.parallaxHeader.minimumHeight = 0;
                                      
                              
                                     break
                                 case .failure(let error):
                                     print("Error: \(error)")
                                 }
                               }
                        
                          }
                          
                      }
                      
                      
                      if imagesInputs.count == 0 {
                          if let img = UIImage(named: "default_store_image") {
                              self.imageView.image = img
                          }
                      }
            
            
            if product.product_type == "price" {
                
                if let currency = product.currency {
                    
                    if let pprice = currency.parseCurrencyFormat(price: Float(product.product_value)){
                        self.productPrice.text = "%@".localized.format(arguments: "\(pprice)")
                        self.productPrice.isHidden = false
                    }
                    
                    if let pprice = currency.parseCurrencyFormat(price: Float(product.original_value)), product.original_value > 0 {
                      
                        let attributeString: NSMutableAttributedString =  NSMutableAttributedString(string: "\(pprice)")
                            attributeString.addAttribute(NSAttributedString.Key.strikethroughStyle, value: 1, range: NSMakeRange(0, attributeString.length))
                    
                        self.original_price_label.attributedText = attributeString
                        self.original_price_label.isHidden = false
                        
                    }else{
                        self.original_price_label.isHidden = true
                    }
                    
                }
                
            }
            
            
            self.productTitle.text = product.name
            
        
            if product.stock > 0 {
                self.stock_label.textColor = Colors.green
                self.stock_label.text = "In stock".localized
                self.stock_label.isHidden = false
            }else if product.stock == 0{
                self.stock_label.textColor = .red
                self.stock_label.text = "Out of stock".localized
                self.stock_label.isHidden = false
            }else{
                stock_label.isHidden = true
            }
            
            
            //setup description
            if product._description != "" {
             
                self.descriptionTextView.delegate = self
                self.descriptionTextView.isUserInteractionEnabled = true // default: true
                self.descriptionTextView.isEditable = false // default: true
                self.descriptionTextView.isSelectable = true // default: true
                self.descriptionTextView.dataDetectorTypes = [.link]
                self.descriptionTextView.isScrollEnabled = false
               
                self.descriptionTextView.textAlignment = .natural
                self.descriptionTextView.tintColor = Colors.primaryColor
            
                //self.descriptionTextView.backgroundColor = UIColor.yellow
            
                let attributedString  = product._description.toHtml().attributedString
                self.descriptionTextView.attributedText = attributedString
                
                DispatchQueue.main.asyncAfter(deadline: .now()+2) {
                    
                    Utils.printDebug("Height-after: \(self.descriptionSubContainer.frame.height)")
                 
                    //ceate a constraint to fix height size
                   self.descriptionSubContainer.translatesAutoresizingMaskIntoConstraints = false
                    
                    let heightConstraint = NSLayoutConstraint(item: self.descriptionSubContainer, attribute: NSLayoutConstraint.Attribute.height, relatedBy: NSLayoutConstraint.Relation.equal, toItem: nil, attribute: NSLayoutConstraint.Attribute.notAnAttribute, multiplier: 1, constant: self.descriptionSubContainer.frame.height)
                    
                    self.descriptionContainer.addConstraints([heightConstraint])
                    self.descriptionContainer.layoutIfNeeded()
                    self.descriptionSubContainer.layoutIfNeeded()
 
                    
                }
                
                
                
            }else{
                self.descriptionContainer.isHidden = true
            }
            
            
        
            let icon = UIImage.init(icon: .googleMaterialDesign(.place), size: CGSize(width: 24, height: 24), textColor: Colors.primaryColor)
            
            self.storeAddress.text = product.store_name
            
            if Utils.isRTL(){
                self.storeAddress.setRightIcon(image: icon)
            }else{
                self.storeAddress.setLeftIcon(image: icon)
            }
            
            self.storeAddress.textColor = UIColor.gray
           
           // self.constraintStoreAddressHeight.constant = size.height+60
            
            //store title
            self.setupNavBarTitles(title: product.name)
            
            //setup order
            self.order_system_setup(product: product)
            
            
            //setup countdouwn
            self.setup_countdown(product: product)
            
            
            //load store
            self.load(store_id: product.store_id)
            
            
            //mark as view
            self.markView()
            
            
            //related products
            self.setupRelatedProduct(product: product)
            
            
            //multipla categoirs
            self.setupMultiCategories(product: product)
            
        
            //setup favourite button
            self.setupFavouriteBtn(product: product)
            
        }
        
    }
    
    
    func setupMultiCategories(product: Product) {
        
        Utils.printDebug("\(product.categories)")
        
        categoriesStackview.spacing = 5
        
        for category in product.categories{
            var label: EdgeLabel = EdgeLabel()
           
            
            label.text = category.nameCat
            label.layer.cornerRadius = label.frame.height/3
            label.layer.masksToBounds = true
            label.backgroundColor = Colors.primaryColor
            label.leftTextInset = 10
            label.rightTextInset = 10
            label.textColor = .white
            label.textAlignment = .center
            label.initBolodFont(size: 14)
            label.roundCorners(radius: 5)
            
            if let color = category.color{
                label.backgroundColor = Utils.hexStringToUIColor(hex: color)
            }
            
            
            categoriesStackview.addArrangedSubview(label)
           
        }
       
    }
    
    func setupRelatedProduct(product: Product) {
        
        /*
         * Start binding offers view
         */
         
        relatedItemsContainer.isHidden = true
         
        relatedItemsContainer.isHidden = false
        relatedItemsContainer
        let style =  CardHorizontalStyle(width: 220, height: 250, type: .Recent_Offers)
        let products = Products_HCards.newInstance(style: style) as! Products_HCards
        products.viewController = self
        
        products.h_label.text = AppConfig.CardTags.TAG_RELATED_PRODUCTS.localized
        products.backgroundColor = .clear
        
        
        if let controller = self.navigationController{
            products.viewNavigationController = controller
        }else{
            products.viewNavigationController = self.tabBarController?.navigationController
        }
            
        
        if let height = style.height{
            products.heightAnchor.constraint(equalToConstant: CGFloat(height)).isActive = true
        }
        
        self.relatedItemsContainer.addSubview(products)
        
        self.relatedItemsContainer.addConstraintsWithFormat(format: "H:|[v0]|", views: products)
        self.relatedItemsContainer.addConstraintsWithFormat(format: "V:|[v0]|", views: products)
        
    
        products.__req_category = product.category_id
        
        if let lastElement = product.categories.last {
            products.__req_category = lastElement.numCat
        }

       
        products.load()
        products.delegate = self
       
         /*
          * End binding offers view
          */
         
    
    }
    
    
    func onProductsLoaded(count: Int) {
        
        if count == 0{
            
            self.relatedItemsContainer.isHidden = true
            UIView.animate(withDuration: 0.3) {
                self.view.layoutIfNeeded()
            }
            
        }else{
            
            self.relatedItemsContainer.isHidden = false
            UIView.animate(withDuration: 0.3) {
                self.view.layoutIfNeeded()
            }
            
        }
        
    }
    
    
    private func order_system_setup(product: Product){
        
        order_button.setTitle("Order".localized, for: .normal)
       
        self.order_button.setTitleColor(.white, for: .normal)
        self.order_button.initBoldFont()
        
        
        //variant block
        self.setupVariantSelector(product: product)
        self.order_button.isHidden = true
    
        DispatchQueue.main.asyncAfter(deadline: .now()+0.5) {
    
            self.order_button.setCustomButtonStyleDefault()
            self.order_button.isHidden = false
           
        }
      
      
    }
    
    
    func setupVariantSelector(product: Product) {
       
        if product.variants.count == 0{
            self.variantSelectorMainContainer.isHidden = true
           return
        }
        
        self.variantSelectorMainContainer.isHidden = false
        
        for group in product.variants {
             let grp = V_Group.newInstance(group: group)
             grp.delagate = self
             variantelectorStackView.addArrangedSubview(grp)
         }
        
        self.setup_variantsButtons(object: product)
       
    }
    
    
    var totalValue: UILabel?
    
    private func setup_variantsButtons(object: Product){
        
        Utils.printDebug("\(object)")
        
        let space = UIView()
        space.heightAnchor.constraint(equalToConstant: 1).isActive = true
        variantelectorStackView.addArrangedSubview(space)
        
        // Create the buttons
        let addToCartButton = UIButton(type: .system)
        addToCartButton.setTitle("Add to Cart".localized, for: .normal)
        addToCartButton.setTitleColor(Colors.primaryColor, for: .normal)
        addToCartButton.addTarget(self, action: #selector(addToCartButtonTapped), for: .touchUpInside)
        addToCartButton.initBoldFont()
        addToCartButton.setCustomButtonControlStyle(active: true)
      
        
        // Create the buttons
        let totalLabel = UILabel()
        totalLabel.text = "Total".localized
        totalLabel.textColor = .black
        totalLabel.initBolodFont(size: 14)
       
        totalLabel.textAlignment = .center
   
        totalValue = UILabel()
        totalValue!.text = "###.0$"
        totalValue?.textAlignment = .center
        
        
        //Display total
        if let d = SyncAppConfig.findById(id: "CURRENCY_OBJECT"){
            let currencyJSON = d.getValue(defaultValue: "USD")
            let currencyParser = CurrencyParser(array: currencyJSON)
            guard let currency = currencyParser.parse() else{
                return
            }
            
            if let p = Product.findById(id: product_id!), let pprice = currency.parseCurrencyFormat(price: Float(p.product_value)){
                if let totalValue = self.totalValue{
                    totalValue.text = pprice
                }
            }
           
        }
        
        totalValue!.textColor = Colors.primaryColor
        totalValue!.initBolodFont(size: 18)
        
        
        // Create the horizontal stack view
        let totalPriceContainer = UIStackView(arrangedSubviews: [totalLabel, totalValue!])
        totalPriceContainer.axis = .vertical
        totalPriceContainer.alignment = .fill
        totalPriceContainer.distribution = .fillEqually
        totalPriceContainer.heightAnchor.constraint(equalToConstant: 50).isActive = true

        
        
        // Create the horizontal stack view
        let stackView = UIStackView(arrangedSubviews: [totalPriceContainer, addToCartButton])
        stackView.axis = .horizontal
        stackView.spacing = 10
        stackView.alignment = .fill
        stackView.distribution = .fillEqually
        stackView.heightAnchor.constraint(equalToConstant: 50).isActive = true

      
        
        variantelectorStackView.addArrangedSubview(stackView)
        variantelectorStackView.spacing = 10
        
    }
    
    // Button tap actions
       @objc func addToCartButtonTapped() {
           
           quickOrderAction()
           
           print("Add to Cart tapped")
       }
   
    
    
    func quickOrderAction() {
        
        guard let id = product_id, let product = Product.findById(id: id) else {
            return
        }
        
       
        var final_amount: Double = Double(product.product_value)
        
        for r in self.variant_selection_result{
            final_amount = final_amount + r.calculated
        }
        
    
        if product.stock >= 1 || product.stock == -1{
            
            let view = qtySelector.show(item: product, amount: Double(final_amount))
            
            view.cancel_btn.setTitle("Add to cart", for: .normal)
            view.confirm_btn.setTitle("Checkout".localized, for: .normal)
            
            qtySelector.delegate = self
            
        }else{
            
            var order_product = OrderProduct()
            order_product.item = product
            order_product.amount = final_amount
            order_product.qty = 1
            order_product.variants = variant_selection_result.toRealmList()
            
            self.startOrderController(product: order_product)
        }
    }
    

    
    var variant_selection_result: [V_GroupResult] = []
    
    //Service selector delegate
    func onUpdated(group: VariantGroup) {
        
        variant_selection_result = []
        //uncheck_all
        for subview in self.variantelectorStackView.subviews{
            if subview is V_Group{
                let grp_view = subview as! V_Group
                let result = getResultSS(grp_view: grp_view)
                self.variant_selection_result.append(result)
            }
        }
    
        var amount = 0.0
        for obj in self.variant_selection_result{
            amount = amount + obj.calculated
        }
        
        if let p = Product.findById(id: product_id!) {
            amount = amount + p.product_value
        }
        
        
        //Display total
        if let d = SyncAppConfig.findById(id: "CURRENCY_OBJECT"){
            let currencyJSON = d.getValue(defaultValue: "USD")
            let currencyParser = CurrencyParser(array: currencyJSON)
            guard let currency = currencyParser.parse() else{
                return
            }
            if let pprice = currency.parseCurrencyFormat(price: Float(amount)){
                order_button.setTitle("Order".localized+" (\(pprice))", for: .normal)
                if let totalValue = self.totalValue{
                    totalValue.text = pprice
                }
            }
        }
        
    }
    
    //Service selector result
    func getResultSS(grp_view: V_Group) ->  V_GroupResult{
        
        var result = V_GroupResult()
        result.grp_id = grp_view.group!.group_id
        result.calculated = 0
        result.grp_label = grp_view.group!.group_label
        result.options = List<VariantOption>()
        
        //uncheck_all
        for subview in grp_view.option_container.subviews{
            
            if subview is V_Option{
               
                let opt_view = subview as! V_Option
                if(opt_view.is_checked){
                    
                    guard  let opt = opt_view.option else {
                        continue
                    }
                   
                    result.options.append(opt)
                    
                    if(opt.value > 0){
                        result.calculated =  result.calculated + opt.value
                    }
                   
                }
               
            }
            
        }
        
        return result
        
    }
    

    
    func setupFavouriteBtn(product: Product){
        
        if product.saved {
            let icon = UIImage(named: "bookmark-filled"); //unsave icon
            favBottomButton.setBackgroundImage(icon, for: .normal)
        }else{
            let icon = UIImage(named: "bookmark"); //unsave icon
            favBottomButton.setBackgroundImage(icon, for: .normal)
        }
    
    }
    
    
    var countDownView: CountDownView?
    func setup_countdown(product: Product) {
        
        product_dates_container.isHidden = true
    
        guard product.is_deal == 1 else {
            self.countDownContainer.isHidden = true
            return
        }
        
        
        countDownView = CountDownView()
        countDownSubContainer.backgroundColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.dealColor)
        countDownSubContainer.roundedCorners()
        
        countDownSubContainer.addSubview(countDownView!)
        countDownView!.setup(width: countDownSubContainer.frame.width-50, height: 30)
        countDownView!.translatesAutoresizingMaskIntoConstraints = false
        
       
        var constraints = [NSLayoutConstraint]()
        
        constraints.append(NSLayoutConstraint(
            item: countDownView!,
            attribute: NSLayoutConstraint.Attribute.centerX,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: countDownSubContainer,
            attribute: NSLayoutConstraint.Attribute.centerX,
            multiplier: 1, constant: 0)
        )
        
        constraints.append(NSLayoutConstraint(
            item: countDownView!,
            attribute: NSLayoutConstraint.Attribute.centerY,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: countDownSubContainer,
            attribute: NSLayoutConstraint.Attribute.centerY,
            multiplier: 1, constant: 0)
        )
        
       
      
        countDownSubContainer.addConstraints(constraints)
        countDownView!.setTime(date_end: product.date_end).runTimer()
              
        
        if(countDownView?.days == 0 &&
            countDownView?.hours == 0 &&
            countDownView?.minutes == 0 &&
            countDownView?.seconds == 0){
            countDownContainer.isHidden = true
        }
    }
    
    
    
    func markView()  {
        
        guard let pid = self.product_id else {
            return
        }
        
        guard Session.isLogged(), let sess = Session.getInstance(), let user = sess.user else {
            return
        }
        
        if let l = LocalData.getValue(key: "\(pid)-\(user.id)", defaultValue: false), l == true{
            return
        }
        
        
        let simpleApi = SimpleRequestApi()
        
        let params = [
            "user_id": "\(user.id)",
            "product_id":"\(pid)"
        ]
        
        simpleApi.run(url: Constances.Api.API_PRODUCT_VIEW_COUNTER, parameters: params) { parser in
            if let p = parser, p.success == 1{
                LocalData.setValue(key: "\(pid)-\(user.id)", value: true)
            }
        }
        
    }
    
    var product_id: Int? = nil
    
    
    //load store
    var productLoader: ProductLoader = ProductLoader()
    
    func load () {
        
        
        self.productLoader.delegate = self
        
        //Get current Location
        
        var parameters = [
            "limit"          : "1"
        ]
        
        if let guest = Guest.getInstance() {
            
            parameters["latitude"] = String(guest.lat)
            parameters["longitude"] = String(guest.lng)
            
            
            if let product_id = self.product_id{
                parameters["product_id"] = String(product_id)
            }
            
        }
        
        Utils.printDebug("\(parameters)")
        
        self.productLoader.load(url: Constances.Api.API_GET_PRODUCTS,parameters: parameters)
        
    }
    
    func success(parser: ProductParser,response: String) {
        
        self.viewManager.showMain()
        
        if parser.success == 1 {
            
            let products = parser.parse()
            
            if products.count > 0 {
                
                products[0].save()
                self.setupProductDetail()
                
            }else{
                viewManager.showAsEmpty()
            }
            
        }else {
            
            if parser.errors != nil {
                viewManager.showAsError()
            }
            
        }
        
    }
    
    

    
    func calculateEstimatedFrame(content: String,fontSize: Float) -> CGSize {
        
        let size = CGSize(width: 250, height: 1000)
        let options = NSStringDrawingOptions.usesFontLeading.union(.usesLineFragmentOrigin)
        let estimatedFrame = NSString(string: content).boundingRect(with: size, options: options, attributes: [NSAttributedString.Key.font : UIFont.systemFont(ofSize: CGFloat(fontSize))], context: nil)
        
        
        let width = estimatedFrame.width
        let height = estimatedFrame.height
        
        return CGSize(width: width, height: height)
    }
    
    var viewManager: LoaderViewManager =  LoaderViewManager()
    
    func setupViewloader()  {
        
        //setup view loader, Error, Empty layouts
        viewManager.setup(parent: view)
        viewManager.getEmptyLayout().delegate = self
        viewManager.getErrorLayout().delegate = self
        
        if Session.isLogged() ==  false {
            
            return
        }else{
            
        }
    }
    
    func onReloadAction(action: EmptyLayout) {
        
    }
    
    func onReloadAction(action: ErrorLayout) {
        
    }
    
    
    
    //load store
    var storeLoader: StoreLoader = StoreLoader()
    
    func load (store_id: Int) {
        
        viewManager.showAsLoading()
    
        self.storeLoader.delegate = self
        
        //Get current Location
        
        var parameters = [
            "limit"          : "1"
        ]
        
        if let guest = Guest.getInstance() {
            
            parameters["latitude"] = String(guest.lat)
            parameters["longitude"] = String(guest.lng)
            
          
            parameters["store_id"] = String(store_id)
           
        }
        
        Utils.printDebug("\(parameters)")
        
        self.storeLoader.load(url: Constances.Api.API_USER_GET_STORES,parameters: parameters)
  
    }
    
    func success(parser: StoreParser,response: String) {
        
        self.viewManager.showMain()
       
        if parser.success == 1 {

            let stores = parser.parse()
           
            if stores.count > 0 {
                
                stores[0].save()
                
            }else{
                viewManager.showAsEmpty()
            }
            
        }else {
            
            if parser.errors != nil {
                viewManager.showAsError()
            }
            
        }
        
    }
    
   
    
    func error(error: Error?,response: String) {
        
        self.viewManager.showAsError()
        
        Utils.printDebug("===> Request Error! ListStores")
        Utils.printDebug("\(response)")
        
    }

    
    func textView(_ textView: UITextView, shouldInteractWith URL: URL, in characterRange: NSRange) -> Bool {
        
        let webVC = SwiftModalWebVC(pageURL: URL, theme: .dark, dismissButtonStyle: .cross, sharingEnabled: true)
        //self.navigationController?.pushViewController(webVC, animated: true)
        self.present(webVC, animated: true, completion: nil)
        
        return false
    }
    

    
    func startOrderController(product: OrderProduct) {
           
        let sb = UIStoryboard(name: "Order", bundle: nil)
        let ms: OrderViewController = sb.instantiateViewController(withIdentifier: "orderVC") as! OrderViewController
     
        ms.cart = Cart.openCart(items: [product])

        self.present(ms, animated: true)
           
    }
    
    
    func startCartController(product: OrderProduct) {
           
        Cart.openCart(items: [product])
        
        let sb = UIStoryboard(name: "CartView", bundle: nil)
         let ms: CartViewController = sb.instantiateViewController(withIdentifier: "cart_vc") as! CartViewController
         ms.parent_controller = self
         self.present(ms, animated: true)
         
        
    }
    
    
    func startLoginVC() {
           
           let sb = UIStoryboard(name: "Login", bundle: nil)
           if sb.instantiateInitialViewController() != nil {
               
               let ms: LoginViewController = sb.instantiateViewController(withIdentifier: "loginVC") as! LoginViewController
               self.present(ms, animated: true)
           }
           
       }
    
    
    func start_vs_CV(item_id: Int) {
           
           let sb = UIStoryboard(name: "VariantSelectorController", bundle: nil)
           if sb.instantiateInitialViewController() != nil {
               
                let ms: VariantSelectorController = sb.instantiateViewController(withIdentifier: "variantSelector_VC") as! VariantSelectorController
                
                ms.item_id = item_id
                ms.modalPresentationStyle = .fullScreen
            ms.parent_controller = self
            
               self.present(ms, animated: true)
           }
           
       }
    
    
}

