//
//  UserParser.swift
//  NearbyStores
//
//  Created by Amine on 5/20/18.
//  Copyright © 2018 Amine. All rights reserved.
//

//
//  JobParser.swift
//  AppTest
//
//  Created by Amine on 5/15/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class ProductParser: Parser {
    
    
    func parse() -> [Product] {
        
        var list = [Product]()
        
        if let myResult = self.result {
            
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    
                   
                    let myObject = Product()
                    
                    myObject.id = object["id_product"].intValue
                    myObject.name = object["name"].stringValue
                    myObject.date_start = object["date_start"].stringValue
                    myObject.date_end = object["date_end"].stringValue
                    myObject.status = object["status"].intValue
                    myObject.store_id = object["store_id"].intValue
                    myObject.store_name = object["store_name"].stringValue
                    myObject.link = object["link"].stringValue
                    myObject.lat = object["latitude"].doubleValue
                    myObject.lng = object["longitude"].doubleValue
                    myObject.distance = object["distance"].doubleValue
                    myObject.user_id = object["user_id"].intValue
                    myObject.featured = object["featured"].intValue
                    myObject.category_id = object["category_id"].intValue
                   
                    let icontent = object["images"]
                    let imageParser = ImagesParser(json: icontent)
                    let images = imageParser.parse()
                    let listImages: List<Images> = List<Images>()
                    
                    for el in images {
                        listImages.append(el)
                    }
                    
                    myObject.listImages = listImages
                    myObject._description = object["description"].stringValue
                    myObject.short_description = object["short_description"].stringValue
                    myObject.product_value = object["product_value"].doubleValue
                    myObject.original_value = object["original_value"].doubleValue
                    myObject.product_type = object["product_type"].stringValue
                    myObject.is_deal = object["is_deal"].intValue
                    myObject.order_enabled = object["order_enabled"].intValue
                    myObject.cf_id = object["cf_id"].intValue
                    myObject.cf = object["cf"].stringValue
                    myObject.order_button = object["order_button"].stringValue
                    
                    
                    if object["saved"].intValue == 1{
                        myObject.saved = true
                    }else{
                        myObject.saved = false
                    }
                    
                    myObject.stock = object["stock"].intValue
                    myObject.store_order_enabled = object["store_order_enabled"].intValue
                    myObject.store_order_based_on_op = object["store_order_based_on_op"].intValue
    
                    let cf_content = object["cf"]
                    let cfParser = CFParser(json: cf_content["result"])
                    let cfields = cfParser.parse()
                    
                    for cf in cfields {
                        myObject.fields.append(cf)
                    }

                    
              
                    if  object["product_type"] == "price"{
                       
                        let currencyJSON = object["currency"]
                        let currencyParser = CurrencyParser(json: currencyJSON)
                        
                        if let currency = currencyParser.parse() {
                            myObject.currency = currency
                        }
                        
                    }
                    
                
                    /*
                    *  Parse variants
                    */
                    
                    let variantsContent = object["variants"]
                    let variantParser = VariantParser(json: variantsContent)
                    let variants = variantParser.parse_group()
                    let variantsList: List<VariantGroup> = List<VariantGroup>()
                    
                    for el in variants {
                        variantsList.append(el)
                    }
                    
                    myObject.variants = variantsList
                    
                    /*
                    *  End parse variants
                    */
                    
                    
                
                    /*
                    *  Parse Categories
                    */
                        
                    let categpriesContent = object["categories"].stringValue
                    let mCategoryParser =  CategoryParser(content: categpriesContent)
                    let categories = mCategoryParser.parse()
                    let categoriesList: List<Category> = List<Category>()
                    for el in categories {
                        categoriesList.append(el)
                    }
                        
                    myObject.categories = categoriesList
                        
                    /*
                    *  End parse variants
                    */
                
                    list.append(myObject)
                    
                }
                
                
            }
            
            
            return list
        }
        
        return []
    }
    
}
