//
//  Banners_HCards.swift
//  NearbyBanners
//
//  Created by Amine  on 8/11/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import Foundation
import UIKit
import SwiftIcons
import SwiftWebVC


class Delivery_HCards: UIView {

    @IBOutlet weak var icon: UIImageView!
    @IBOutlet weak var banner_container: UIView!
    @IBOutlet weak var db_title: UILabel!
    @IBOutlet weak var db_description: UILabel!
    
    
    @IBOutlet weak var container_constraint_left: NSLayoutConstraint!
    @IBOutlet weak var container_constraint_right: NSLayoutConstraint!

    
    class func instanceFromNib(name: String) -> UIView {
        return UINib(nibName: name, bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! UIView
    }

    
    var style: CardHorizontalStyle?

    var viewController: UIViewController? = nil
    var viewNavigationController: UINavigationController? = nil
    var viewTabBarController: UITabBarController? = nil


    static func newInstance(style: CardHorizontalStyle) -> UIView {

        //load xib 
        let Delivery_HCards = instanceFromNib(name: "Delivery_HCards") as! Delivery_HCards
        Delivery_HCards.setup(style: style)
  
        return Delivery_HCards

    }


    //RESULT
    var GLOBAL_COUNT: Int = 0
    var LIST: [Banner] = [Banner]()


    let padding_size = CGFloat(20)

    let padding = CGFloat(20)

 
    func setup(style: CardHorizontalStyle) {
        
        self.banner_container.addShadowView()
        
        self.banner_container.backgroundColor = Colors.primaryColor
        
        self.db_title.initBolodFont(size: 20)
        self.db_description.initItalicFont(size: 14)
        self.db_title.textColor = .white
        self.db_description.textColor = .white
        self.db_title.text = AppConfig.APP_NAME+" "+"delivery".localized
        self.db_description.text = "Get it now and make money by delivering orders".localized
        
        container_constraint_left.constant = padding_size
        container_constraint_right.constant = padding_size

        let d_icon = UIImage(named: "delivery-icon")?.withRenderingMode(.alwaysTemplate)
        self.icon.image = d_icon
        self.icon.tintColor = Colors.darkColor
        
        
        self.backgroundColor = .clear
        self.style = style
        
        
        self.banner_container.isUserInteractionEnabled = true
        let gestureRecognizerImageView = UITapGestureRecognizer(target: self, action: #selector(didTapOn))
        self.banner_container.addGestureRecognizer(gestureRecognizerImageView)
        

    }
    
    @objc func didTapOn() {
        
        if let app_store = SyncAppConfig.findById(id: "DELIVERY_IOS_LINK")
           , app_store.getValue(defaultValue: "") != "" {
            if let url = URL(string: app_store.getValue(defaultValue: "")) {
                if #available(iOS 10.0, *) {
                    UIApplication.shared.open(url, options: [:], completionHandler: nil)
                } else {
                    // Fallback on earlier versions
                }
            }
        }
    
        
    }



}

