//
//  File.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit


protocol QtyViewDelegate {
    func rightClick(qty: Double)
    func leftClick()
}

class QtyView : UIView{
    
    
    var delegate: QtyViewDelegate? = nil
    
    
    var qty = 1.0
    var item: Product? = nil
    var amount: Double? = nil
    
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var cancel_btn: UIButton!
    @IBOutlet weak var confirm_btn: UIButton!
    @IBOutlet weak var item_title: UILabel!
    @IBOutlet weak var item_sub_title: UILabel!
    @IBOutlet weak var plus: UIButton!
    @IBOutlet weak var less: UIButton!
    @IBOutlet weak var qty_label: UILabel!
    
    
    @IBAction func plus_action(_ sender: Any) {
        
        qty = qty+1
        
       updateQtyLabel()
        updatePriceLabel()
    }
    
    @IBAction func less_action(_ sender: Any) {
        
        if qty > 1{
            qty = qty-1
        }else{
            qty = 1
        }
        
        
        updateQtyLabel()
        updatePriceLabel()
        
    }
    
    @IBAction func cancel_action(_ sender: Any) {
        
        if let del = delegate{
            del.leftClick()
        }
        
    }
    
    @IBAction func confirm_action(_ sender: Any) {
    
        if let del = delegate{
            del.rightClick(qty: qty)
        }
        
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
  
    
    static func newInstance() ->  QtyView{
        
          let view:QtyView = UINib(nibName: "QtyView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! QtyView
        
        
         view.initViews()
      
        
          //view.frame = CGRect(x: 0, y: 0, width: view.frame.width, height: view.frame.height + 20.0)
          return view
      }
    
    
    
    func setup(item: Product, qty:Double, amount: Double)  {
        
        self.item = item
        self.amount = amount
        
        
        if item.listImages.count>0 {
                   
            if item.listImages[0].url500_500 != ""{
                let url = URL(string: item.listImages[0].url500_500)
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
                   
                   
        }else{
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        self.item_title.text = item.name
             
        updatePriceLabel()
        updateQtyLabel()
        
        
    }
    
    
    private func updateQtyLabel()  {
    
        self.qty_label.text = "\(Int(qty))"
    
    }
    
    
    private func updatePriceLabel()  {
        
        guard let item = self.item else {
            return
        }
        
        if item.product_type == "price" {
                   
            if let currency = item.currency {
                
                if let value = self.amount, let pprice = currency.parseCurrencyFormat(price: Float(value) * Float(qty)){
                    self.item_sub_title.text = pprice
                }else if let pprice = currency.parseCurrencyFormat(price: Float(item.product_value) * Float(qty)){
                    self.item_sub_title.text = pprice
                }
               
            }
                   
        }else if item.product_type == "percent" {
             
            self.item_sub_title.text = "Offer".localized
           
        }else{
            
             if let currency = item.currency {
                if let pprice = currency.parseCurrencyFormat(price: 0.0 * Float(qty)){
                    self.item_sub_title.text = pprice
                }
            }
        }
          
    }
    
    func initViews()  {
        
        self.item_title.initBolodFont(size: 18)
        self.item_sub_title.initDefaultFont(size: 14)
        self.item_sub_title.textColor = .gray
              
        self.less.initBoldFont(size: 28)
        self.less.setTitleColor(.black, for: .normal)
              
        self.plus.initBoldFont(size: 28)
        self.plus.setTitleColor(.black, for: .normal)
              
        self.qty_label.initDefaultFont(size: 16)
              
              
              
        self.cancel_btn.initDefaultFont()
        self.cancel_btn.setTitleColor(.darkGray, for: .normal)
              
        self.confirm_btn.initBoldFont(size: 16)
        self.confirm_btn.setTitleColor(Colors.primaryColor, for: .normal)
        self.confirm_btn.setCustomButtonStyleRounded()
        
    }
   

}
