//
//  OptionsLauncher.swift
//  NearbyStores
//
//  Created by Amine on 6/29/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import AssistantKit


protocol QtySelectorDelegate {
    func onQtySelectorRightPressed(qty: Double)
    func onQtySelectorLeftPressed(qty: Double)
}


class QtySelectorView: NSObject, QtyViewDelegate{
    
    
    func rightClick(qty: Double) {
        
        if let v = self.qtyView, let del = delegate{
            del.onQtySelectorRightPressed(qty: v.qty)
        }
        
        handleDismiss()
    }
    
    func leftClick() {
        
        if let v = self.qtyView, let del = delegate{
            del.onQtySelectorLeftPressed(qty: v.qty)
        }
        
        handleDismiss()
    }
    
    
    var delegate: QtySelectorDelegate? = nil
    let blackView = UIView()

    var qtyView: QtyView? = nil
    
    
    func show(item: Product,amount: Double) ->  QtyView{
        //show menu
        
        
        if let window = UIApplication.shared.keyWindow {
            
            blackView.backgroundColor = UIColor(white: 0, alpha: 0.5)
            blackView.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(handleDismiss)))
            
            window.addSubview(blackView)
            
            
            let height: CGFloat = 140+50+50
            let y = window.frame.height - height
            
            qtyView = QtyView.newInstance()
            qtyView?.setup(item: item, qty: 1, amount: amount)
            qtyView?.delegate = self

            window.addSubview(qtyView!)
            
            qtyView?.roundCorners(corners: [.topRight, .topLeft], radius: 20)
            
        
            qtyView!.frame = CGRect(x: 0, y: window.frame.height, width: window.frame.width, height: height)
            
            blackView.frame = window.frame
            blackView.alpha = 0
            
            UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
                
                self.blackView.alpha = 1
                self.qtyView!.frame = CGRect(x: 0, y: y, width: self.qtyView!.frame.width, height: self.qtyView!.frame.height)
                
            }, completion: nil)
        }
        
        return qtyView!
    }
    
    @objc func handleDismiss() {
        
        UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
            
            self.blackView.alpha = 0
            
            if let window = UIApplication.shared.keyWindow {
                self.qtyView!.frame = CGRect(x: 0, y: window.frame.height, width: self.qtyView!.frame.width, height: self.qtyView!.frame.height)
            }
            
        }) { (completed: Bool) in
           
        }
    }
    
    
    override init() {
        super.init()
        
        
    }
    
  
    
    func createIcon(_ icon: FontType) -> UIImage {
        return UIImage.init(icon: icon, size: CGSize(width: 25, height: 25), textColor: UIColor.darkGray)
    }
    
    
    
}

