//
//  File.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit

protocol PayNowDelegate:class  {
    //func successUtf8(data: String)
    func onPayNowPressed()
}


class CustomButtonView : UIView{

    var delegate: PayNowDelegate?
    
    @IBOutlet weak var pay_button: UIButton!
    @IBAction func pay_action(_ sender: Any) {
        
        if let del = delegate{
            del.onPayNowPressed()
        }
    }
    
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    static func newInstance() ->  CustomButtonView{
          let view:CustomButtonView = UINib(nibName: "PayButtonView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! CustomButtonView
          //view.frame = CGRect(x: 0, y: 0, width: view.frame.width, height: view.frame.height + 20.0)
          return view
      }
    
    func setup(title:String) -> CustomButtonView{
        
        pay_button.backgroundColor = Colors.primaryColor
        pay_button.setTitle(title.localized, for: .normal)
        pay_button.setTitleColor(.white, for: .normal)
        pay_button.initItalicFont()
        
        return self
    }
    
   

}
