//
//  File.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/12/20.
//  Copyright © 2020 Amine. All rights reserved.
//


import Foundation
import UIKit

protocol CustomButtonDelegate:class  {
    //func successUtf8(data: String)
    func onCBPressed(object: CustomButtonView)
}


class CustomButtonView : UIView{

    var id = 0
    var delegate: CustomButtonDelegate?
    
    @IBOutlet weak var button: UIButton!
    
    @IBAction func press_action(_ sender: Any) {
        
        if let del = delegate{
            del.onCBPressed(object: self)
        }
    }
    
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    static func newInstance() ->  CustomButtonView{
          let view:CustomButtonView = UINib(nibName: "CustomButtonView", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! CustomButtonView
          //view.frame = CGRect(x: 0, y: 0, width: view.frame.width, height: view.frame.height + 20.0)
          return view
      }
    
    func setup(title:String) -> CustomButtonView{
        
        button.backgroundColor = Colors.primaryColor
        button.setTitle(title.localized, for: .normal)
        button.setTitleColor(.white, for: .normal)
        button.initItalicFont()
        
        return self
    }
    
   

}
