//
//  TitleView.swift
//  DealifyDeliveryBoy
//
//  Created by Amine  on 2/8/21.
//  Copyright © 2021 Amine. All rights reserved.
//

import UIKit

protocol CouponInputDialogDelegate {
    func onApply(couponCode: String)
}

class CouponInputDialog: UIView{
    
    var delegate:CouponInputDialogDelegate?
    
    static func newInstance() ->  CouponInputDialog{
        
        return UINib(nibName: "CouponInputDialog", bundle: nil).instantiate(withOwner: nil, options: nil)[0] as! CouponInputDialog
    
    }
    
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }
       
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
  
    
    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var applyBtn: UIButton!
    @IBOutlet weak var couponField: UITextField!
    
    @IBAction func applyAction(_ sender: Any) {
        
        if let del = delegate{
            del.onApply(couponCode: couponField.text!)
        }
        
    }
    
    
    func setup()  {
        
        
        label.initBolodFont()
        applyBtn.initBoldFont()
        couponField.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 14)
        couponField.placeholder = "Enter your coupon".localized
       
        applyBtn.setCustomButtonControlStyle(active: true)
    }
   

}


protocol CouponInputDialogLauncherDelegate {
    func onCouponApply(code:String)
}
class CouponInputDialogLauncher: NSObject, CouponInputDialogDelegate{
    
    func onApply(couponCode: String) {
        
        if let del = delegate{
            del.onCouponApply(code: couponCode)
        }
        
        handleDismiss()
        
    }
    
    
    var delegate:CouponInputDialogLauncherDelegate?
    
    let blackView = UIView()
    var mCouponInputDialog: CouponInputDialog? = nil
    
    
    func show() ->  CouponInputDialog{
        //show menu
        
        
        if let window = UIApplication.shared.keyWindow {
            
            blackView.backgroundColor = UIColor(white: 0, alpha: 0.5)
            blackView.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(handleDismiss)))
            
            window.addSubview(blackView)
            
            
            let height: CGFloat = 140+50+10
            let y = window.frame.height - height
            
            mCouponInputDialog = CouponInputDialog.newInstance()
            mCouponInputDialog?.setup()
            mCouponInputDialog?.delegate = self

            window.addSubview(mCouponInputDialog!)
            
            mCouponInputDialog?.roundCorners(corners: [.topRight, .topLeft], radius: 20)
            
        
            mCouponInputDialog!.frame = CGRect(x: 0, y: window.frame.height, width: window.frame.width, height: height)
            
            blackView.frame = window.frame
            blackView.alpha = 0
            
            UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
                
                self.blackView.alpha = 1
                self.mCouponInputDialog!.frame = CGRect(x: 0, y: y, width: self.mCouponInputDialog!.frame.width, height: self.mCouponInputDialog!.frame.height)
                
            }, completion: nil)
        }
        
        return mCouponInputDialog!
    }
    
    @objc func handleDismiss() {
        
        UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
            
            self.blackView.alpha = 0
            
            if let window = UIApplication.shared.keyWindow {
                self.mCouponInputDialog!.frame = CGRect(x: 0, y: window.frame.height, width: self.mCouponInputDialog!.frame.width, height: self.mCouponInputDialog!.frame.height)
            }
            
        }) { (completed: Bool) in
           
        }
    }
    
    
    override init() {
        super.init()
        
        
    }
    
    
}


