//
//  CustomField.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/10/20.
//  Copyright © 2020 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class CustomFields: Object{
    
    @objc dynamic var id: Int = 0
    @objc dynamic var label: String = ""
    var fields: List<CField> = List<CField>()

    override static func primaryKey() -> String? {
        return "id"
    }
    
    
    static func save_cache(id: Int, key: String, value: String) {
        
        guard let sess = Session.getInstance(), let user = sess.user else {
            return
        }
        
        LocalData.setValue(key: "\(id)_\(key)_\(user.id)", value: value)
        
    }
    
    static func get_cache(id: Int,key: String) -> String{
        
        guard let sess = Session.getInstance(), let user = sess.user else {
            return ""
        }
           
        return LocalData.getValue(key: "\(id)_\(key)_\(user.id)", defaultValue: "")
           
    }
}


class CField: Object{
    
    @objc dynamic var id: String = ""
    @objc dynamic var type: String = ""
    @objc dynamic var label: String = ""
    @objc dynamic var required: Int = 0
    @objc dynamic var order: Int = 0
    @objc dynamic var step: Int = 0
    @objc dynamic var fill_field: String = ""

    override static func primaryKey() -> String? {
        return "id"
    }
    
}


