//
//  OrderParser.swift
//  NearbyStores
//
//  Created by Amine on 7/12/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftyJSON
import RealmSwift

class OrderParser: Parser {
    
    func parse() -> [Order] {
        
        var list = [Order]()
        
        if let myResult = self.result {
            
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    let myObject = Order()
                    
                    myObject.id = object["id"].intValue
                    myObject.user_id = object["user_id"].intValue
                    myObject.status = object["status"].stringValue
                    myObject.invoice = object["invoice"].intValue
                    myObject.payment_status = object["payment_status_data"].stringValue
                    myObject.amount = object["amount"].doubleValue
                    myObject.created_at = object["created_at"].stringValue
                    myObject.delivery_status = object["delivery_status"].intValue
                   
                    myObject.delivery_id = object["delivery_id"].intValue
                    myObject.store_id = object["module_id"].intValue
                    myObject.extras = object["extras"].stringValue
                    
                    
                    myObject.extrasValue = object["extrasValue"].doubleValue
                    myObject.discountsValue = object["discountsValue"].doubleValue
                    myObject.taxesValue = object["taxesValue"].doubleValue
                    
                    
                    let timelineContent = object["timeline"].stringValue
                    let timeline = TLPoint.parse(order_id: object["id"].intValue, string: timelineContent)
                    let timelineList: List<TLPoint> = List<TLPoint>()
                    
                    
                    for tl in timeline {
                        timelineList.append(tl)
                    }
                    
                    myObject.timeline = timelineList
                    
                    
                    let icontent = object["items"]
                    let itemParser = OrderItemParser(json: icontent)
                    
                    for item in itemParser.parse(order_id:  myObject.id) {
                        myObject.items.append(item)
                    }
                    
                    
                    list.append(myObject)
                    
                }
              
            }
          
            
            return list
        }
        
        return []
    }
}


extension OrderParser{
    
    static func parse_extras(order: Order) -> [String: Double] {
        
        var result:[String: Double] =  [:]
        let extras = order.extras
        
        guard extras != "" else {
            return result
        }
        
        if let dataFromString = extras.data(using: .utf8, allowLossyConversion: false) {
            
            do {
                
                let json = try JSON(data: dataFromString)
              
               
                for (key, value) in json {
                    result[key] = value.doubleValue
                }
                
            
            } catch {
               
            }
               
        }
        
        return result
    }
    
}


class OPaymentParser: Parser {
    
    func parse() -> [OrderPayment] {
        
        var list = [OrderPayment]()
        
        if let myResult = self.result {
            
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    let myObject = OrderPayment()
                    
                    myObject.id = object["id"].stringValue
                    myObject.method = object["payment"].stringValue
                    myObject.image = object["image"].stringValue
                    myObject.image = object["image"].stringValue
                    myObject.payment_desctiption = object["description"].stringValue

                
                    let taxJson =  object["taxes"]
                    let tax = OrderPaymentTax()
                    
                    tax.id = taxJson["id"].intValue
                    tax.name = taxJson["name"].stringValue
                    tax.value = taxJson["value"].doubleValue
                    
                    myObject.tax = tax
                    
                    list.append(myObject)
                    
                }
                
                
            }
            
            
            return list
        }
        
        return []
    }
}

extension TLPoint{
    
    static func parse(order_id: Int, string: String) -> [TLPoint] {
        
        var json: JSON? = nil
        
        
        if let dataFromString = string.data(using: .utf8, allowLossyConversion: false) {
             do {
                 json = try JSON(data: dataFromString)
             } catch {
                return []
             }
         }
         
        var list = [TLPoint]()
    
        if json!.count > 0 {
            
            let size = json!.count-1
            
            for index in 0...size {
                
                let object = json![ String(index) ]
                
                let myObject = TLPoint()
               
                myObject.id = "\(object["sid"].intValue)"
                myObject.date = object["date"].stringValue
                myObject.status = object["status"].stringValue
                myObject.message = object["message"].stringValue
               
                Utils.printDebug("\(object) - \(json!)")
                Utils.printDebug("\(myObject)")
                
                list.append(myObject)
            }
        }
        
        return list
    }
    
    

}
