//
//  OfferCell.swift
//  NearbyStores
//
//  Created by Amine on 6/7/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import SkeletonView

class OfferCell: UICollectionViewCell {

    @IBOutlet weak var container_shadow: UIView!
    @IBOutlet weak var container: UIView!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var featured: EdgeLabel!
    @IBOutlet weak var offer: EdgeLabel!
    @IBOutlet weak var distance: EdgeLabel!
    @IBOutlet weak var store_name: UILabel!
    @IBOutlet weak var title: UILabel!
    
    @IBOutlet weak var deal_label: EdgeLabel!
    
    func setupSettings()  {
        
        
         // radius & shadowing style
        container_shadow.addShadowView(width:1, height:5, opcaity:0.1, maskToBounds:false, radius:5)
        container.roundedCorners(radius: 20)
          
        
        //offers tag
        offer.leftTextInset = 8
        offer.rightTextInset = 8
        offer.topTextInset = 4
        offer.bottomTextInset = 4
        offer.backgroundColor = Colors.promoTagColor
        offer.initBolodFont()
        offer.sizeToFit()
        offer.roundedCorners()
        
        distance.initBolodFont()

        
        featured.leftTextInset = 12
        featured.rightTextInset = 12
        featured.bottomTextInset = 8
        featured.topTextInset = 8
        featured.backgroundColor = Colors.featuredTagColor
        featured.text = "Featured".localized.uppercased()
        featured.initDefaultFont()
        featured.roundedCorners()
        
        
        deal_label.leftTextInset = 12
        deal_label.rightTextInset = 12
        deal_label.topTextInset = 8
        deal_label.bottomTextInset = 8
        deal_label.backgroundColor = Colors.dealColor
        deal_label.initBolodFont()
        deal_label.roundedCorners()
        deal_label.text = ""
        deal_label.textColor = .darkGray
        
        image.contentMode = .scaleAspectFill
        
        title.initBolodFont(size: 16)
        store_name.initDefaultFont(size: 14)
        
        
        self.featured.text = ""
        self.featured.setIcon(icon: .linearIcons(.pushpin), iconSize: 18, color: .white, bgColor: Colors.featuredTagColor)
        

        self.deal_label.text = ""
        self.deal_label.setIcon(icon: .googleMaterialDesign(.timer), iconSize: 18, color: .white, bgColor: Colors.dealColor)
        
        
    }
    
    func setup(object: Offer)  {
        
        
        guard object.id > 0 else {
            makeAsLoader()
            return
        }
        
        makeAsDefault()
        
        
        self.title.text = object.name
        self.store_name.text = object.store_name
        
       
        
        let icon = UIImage.init(icon: .googleMaterialDesign(.place), size: CGSize(width: 24, height: 24), textColor: UIColor.gray)
        
        if Utils.isRTL(){
            self.store_name.setRightIcon(image: icon)
        }else{
           self.store_name.setLeftIcon(image: icon)
        }
        
        
        if object.listImages.count>0 {
            
            if object.listImages[0].url500_500 != ""{
                let url = URL(string: object.listImages[0].url500_500)
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                }
            }
            
            
        }else{
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        
        if object.featured == 1 {
            self.featured.isHidden = false
        }else {
            self.featured.isHidden = true
        }
        
        
        if object.offer_type == "price" {
            
            if let currency = object.currency {
                if let pprice = currency.parseCurrencyFormat(price: Float(object.offer_value)){
                    offer.text = pprice
                }
            }
            
        }else if object.offer_type == "percent" {
            offer.text = "\(Int(object.offer_value))%"
            
        }else{
            offer.text = "Promotion".localized
        }
        
      
        if object.is_deal == 1{
            deal_label.isHidden = false
        }else{
            deal_label.isHidden = true
        }
        
        
        
        let distance = object.distance.calculeDistance()
        self.distance.text = distance.getCurrent()
     
        if MyLocation.isProvided{
            self.distance.isHidden = false
        }else{
            self.distance.isHidden = true
        }
        
        
        
    }
    
    

    
    func setupDeal(date_end: String) {
              
        var countDown = ""
    
            if let timer = getDiffTime(date_end_UTC: date_end) {
                
               
               
                  if(isLessThan1Second(components: timer.dateComponents!)){
                    self.deal_label.text = "00:00:00:00"
                    self.deal_label.isHidden = true
                    return
                  }
                
                
                
                  if(timer.days<10 && timer.days>=0){
                    countDown = countDown+"0\(timer.days)"
                  }else{
                    countDown = countDown+"\(timer.days)"
                  }
              
                  
                  if(timer.hours<10 && timer.hours>=0){
                      countDown = countDown+":0\(timer.hours)"
                  }else{
                      countDown = countDown+":\(timer.hours)"
                  }
                  
                  
                  if(timer.minutes<10 && timer.minutes>=0){
                      countDown = countDown+":0\(timer.minutes)"
                  }else{
                       countDown = countDown+":\(timer.minutes)"
                  }
                  
                
                   if(timer.seconds<10 && timer.seconds>=0){
                      countDown = countDown+":0\(timer.seconds)"
                   }else{
                       countDown = countDown+":\(timer.seconds)"
                   }
               
               
                 self.deal_label.text = countDown
                
                self.deal_label.isHidden = false
                
              }
            
          }
    
    
    
      func isLessThan1Second(components: DateComponents) -> Bool {
             
             if components.year!<0{
                 return true
             }
             
             if components.month!<0{
                 return true
             }
             
             if components.day!<0{
                 return true
             }
             
             if components.hour!<0{
                 return true
             }
             
             if components.minute!<0{
                 return true
             }
             
             if components.second!<0{
                 return true
             }
             
             guard components.year! >= 0 else { return false }
             guard components.month! >= 0 else { return false }
             guard components.day! >= 0 else { return false }
             guard components.hour! >= 0  else { return false }
             guard components.minute! >= 0  else { return false }
             guard components.second! < 0  else { return false }
             
            
             return true
         }
      
    
    
       func getDiffTime(date_end_UTC: String) -> MyTime?{
           
            let dateRangeStart = Date()
           
           if let dateEnd = DateUtils.convertToDate(dateUTC: date_end_UTC) {
               
                let components = Calendar.current.dateComponents([.year, .month, .day, .hour, .minute, .second], from: dateRangeStart, to: dateEnd)
               
               var time = MyTime()
               time.days = components.day!
               time.hours = components.hour!
               time.minutes = components.minute!
               time.seconds = components.second!
               time.dateComponents = components
               
               return time
               
           }
           
           return nil
       }
       
    
    
      func makeAsDefault() {
         
          self.image.isSkeletonable = false
          self.title.isSkeletonable = false
          self.store_name.isSkeletonable = false
          
          self.image.hideSkeleton()
          self.title.hideSkeleton()
          self.store_name.hideSkeleton()

          
          self.featured.isHidden = false
          self.offer.isHidden = false
         self.store_name.isHidden = false
        self.distance.isHidden = false
        
      }
      
      
      func makeAsLoader() {
          
    
          self.image.isSkeletonable = true
          self.title.isSkeletonable = true
          self.store_name.isSkeletonable = true
          
          self.image.showAnimatedSkeleton()
          self.title.showAnimatedGradientSkeleton()
          self.store_name.showAnimatedGradientSkeleton()
          
          self.featured.isHidden = true
          self.offer.isHidden = true
          self.deal_label.isHidden = true
          self.featured.isHidden = true
        self.store_name.isHidden = true
        self.distance.isHidden = true
         
          
      }
    
}










