//
//  Offer.swift
//  NearbyStores
//
//  Created by Amine on 5/20/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class Offer: Object {
    

    @objc dynamic var id: Int = 0
    @objc dynamic var store_id: Int = 0
    @objc dynamic var user_id: Int = 0
    @objc dynamic var status: Int = 0
    @objc dynamic var date_start: String = ""
    @objc dynamic var date_end: String = ""
    @objc dynamic var name: String = ""
    @objc dynamic var store_name: String = ""
    var listImages: List<Images> = List<Images>()
    @objc dynamic var distance: Double = 0
    @objc dynamic var lat: Double = 0
    @objc dynamic var lng: Double = 0
    @objc dynamic var featured: Int = 0
    @objc dynamic var link: String = ""
    
    @objc dynamic var offer_type: String = ""
    @objc dynamic var offer_value: Double = 0
    @objc dynamic var currency: Currency? = nil
    @objc dynamic var _description: String = ""
    @objc dynamic var short_description: String = ""
    
    
    
    @objc dynamic var is_deal: Int = 0
    @objc dynamic var order_enabled: Int = 0
    @objc dynamic var cf_id: Int = 0
    @objc dynamic var cf: String = ""
    @objc dynamic var order_button: String = ""
    
     @objc dynamic var stock: Int = 0
    
    
    var variants: List<VariantGroup> = List<VariantGroup>()
    
    var fields: List<CustomFields> = List<CustomFields>()
    

    override static func primaryKey() -> String? {
        return "id"
    }
}


extension Offer{
    
    func save() {
        if self.id > 0 {
            
            let offer = self
            
            let realm = try! Realm()
            realm.beginWrite()
            realm.add(offer,update: .all)
            try! realm.commitWrite()
            
        }
    }
    
    static func findById(id: Int) -> Offer? {
        
        let realm = try! Realm()
        
        if let offer = realm.objects(Offer.self).filter("id == \(id)").first {
            return offer
        }
        
        return nil
    }
}

extension Offer{
    
    func copyProduct() -> Product {
        
        if let product = Product.findById(id: self.id) {
           
            let realm = try! Realm()
            
            realm.beginWrite()
        
            product.store_id = self.store_id
            product.user_id = self.user_id
            product.status = self.status
            product.date_start = self.date_start
            product.date_end = self.date_end
            product.name = self.name
            product.store_name = self.store_name
            product.listImages = self.listImages
            product.distance = self.distance
            product.lat = self.lat
            product.lng = self.lng
            product.featured = self.featured
            product.link = self.link
            product.product_type = self.offer_type
            product.product_value = self.offer_value
            product.currency = self.currency
            product._description = self._description
            product.short_description = self.short_description
            product.is_deal = self.is_deal
            product.order_enabled = self.order_enabled
            product.cf_id = self.cf_id
            product.order_button = self.order_button
            product.stock = self.stock
            product.variants = self.variants
            product.fields = self.fields
         
            try! realm.commitWrite()
            
            return product
            
        }else{
            
            let product = Product()
            product.id = self.id
            product.store_id = self.store_id
            product.user_id = self.user_id
            product.status = self.status
            product.date_start = self.date_start
            product.date_end = self.date_end
            product.name = self.name
            product.store_name = self.store_name
            product.listImages = self.listImages
            product.distance = self.distance
            product.lat = self.lat
            product.lng = self.lng
            product.featured = self.featured
            product.link = self.link
            product.product_type = self.offer_type
            product.product_value = self.offer_value
            product.currency = self.currency
            product._description = self._description
            product.short_description = self.short_description
            product.is_deal = self.is_deal
            product.order_enabled = self.order_enabled
            product.cf_id = self.cf_id
            product.order_button = self.order_button
            product.stock = self.stock
            product.variants = self.variants
            product.fields = self.fields
            return product
            
        }
        
        
    }
    
}
