//
//  MenuBar.swift
//  NearbyStores
//
//  Created by Amine on 5/29/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import BadgeSwift


protocol MenuBarDelegate:class  {
    //func successUtf8(data: String)
    func scrollToMenuIndex(index: Int)
}

class MenuBar: UIView, UICollectionViewDataSource, UICollectionViewDelegate, UICollectionViewDelegateFlowLayout {
    
    
    var delegate: MenuBarDelegate? = nil
    
    func setDelegate(context: MenuBarDelegate) {
        delegate = context
    }
    
    var badgeCount = 0
    func refreshBadge(at: IndexPath, count: Int,current: Int) {
        
        
        badgeCount = count
        collectionView.reloadItems(at: [at])
        
        //collectionView.selectItem(at: current, animated: true, scrollPosition: .left)
       
    }
    
    func refreshBadge(at: IndexPath, count: Int,current: IndexPath) {
        
        
        badgeCount = count
        collectionView.reloadItems(at: [at])
        
        collectionView.selectItem(at: current, animated: true, scrollPosition: .left)
        
    }
    
    
   
   
    lazy var collectionView: UICollectionView = {
        let layout = UICollectionViewFlowLayout()
        let cv = UICollectionView(frame: .zero, collectionViewLayout: layout)
        cv.backgroundColor = AppDesignUtils.defaultModeColor(dark:  Colors.primaryColor, light: .white)
        cv.dataSource = self
        cv.delegate = self
        return cv
    }()
    
    let cellId = "cellId"
   
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        collectionView.register(MenuCell.self, forCellWithReuseIdentifier: cellId)
        
        addSubview(collectionView)
        addConstraintsWithFormat(format: "H:|[v0]|", views: collectionView)
        addConstraintsWithFormat(format: "V:|[v0]|", views: collectionView)
        
        let selectedIndexPath = IndexPath(item: 0, section: 0)
        collectionView.selectItem(at: selectedIndexPath, animated: false, scrollPosition: .right)
        
        setupHorizontalBar()
    }
    
    
    var horizontalBarLeftRightAnchorConstraint: NSLayoutConstraint?
   
    
    func setupHorizontalBar() {
        
        let horizontalBarView = UIView()
        horizontalBarView.backgroundColor = Colors.white
        addSubview(horizontalBarView)
        

        horizontalBarView.translatesAutoresizingMaskIntoConstraints = false
       
      
        let nbrtabs = CGFloat(AppConfig.HomeStruct.Pages.count)
       
        horizontalBarLeftRightAnchorConstraint = horizontalBarView.leftAnchor.constraint(equalTo: self.leftAnchor)
        horizontalBarLeftRightAnchorConstraint?.isActive = true
        
        horizontalBarView.widthAnchor.constraint(equalTo: self.widthAnchor, multiplier: 1/nbrtabs).isActive = true
        horizontalBarView.heightAnchor.constraint(equalToConstant: 3).isActive = true
        horizontalBarView.bottomAnchor.constraint(equalTo: self.bottomAnchor).isActive = true
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        let x = CGFloat(indexPath.item) * frame.width / CGFloat(AppConfig.HomeStruct.Pages.count)
        horizontalBarLeftRightAnchorConstraint?.constant = x
        
       
        UIView.animate(withDuration: 0.75, delay: 0, usingSpringWithDamping: 1, initialSpringVelocity: 1, options: .curveEaseOut, animations: {
            self.layoutIfNeeded()
        }, completion: nil)
        
    
        if let deleg = delegate {
            deleg.scrollToMenuIndex(index: indexPath.item)
        }
        
        
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return Int(AppConfig.HomeStruct.Pages.count)
    }
    
  
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: cellId, for: indexPath) as! MenuCell
        
        let index = AppConfig.HomeStruct.Pages[indexPath.item]
        
        if let tabicon = AppConfig.HomeStruct.TabIcons[index], let tabicon1 = tabicon as? [String],  let inactiveIcon = UIImage(named: tabicon1[0])
           , let activeIcon = UIImage(named: tabicon1[1]){
            
            if indexPath.item == 0{
                cell.imageView.image = activeIcon.withRenderingMode(.alwaysTemplate)
            }else{
                cell.imageView.image = inactiveIcon.withRenderingMode(.alwaysTemplate)
            }
          
            cell.activeImage = activeIcon.withRenderingMode(.alwaysTemplate)
            cell.inactiveImage = inactiveIcon
            
        }else{
            
            if let tabicon = AppConfig.HomeStruct.TabIcons[index], let tabicon1 = tabicon as? String, let icon = UIImage(named: tabicon1){
                
                 cell.imageView.image = icon.withRenderingMode(.alwaysTemplate)
                
            }else{
                
                var color = AppDesignUtils.defaultModeColor(dark:  Colors.primaryColor, light: UIColor.gray.withAlphaComponent(0.5))
                

                if AppStyle.Config.uiColor == AppStyle.uiColor.light{
                    color = UIColor.gray.withAlphaComponent(0.5)
                }else{
                    color = Colors.primaryColor
                }
                
                
                
                let _icon = UIImage.init(icon: .linearIcons(.mapMarker), size: CGSize(width: 35, height: 35), textColor: color)
                cell.imageView.image = _icon.withRenderingMode(.alwaysTemplate)
                
            }
            
        }
        
        /*if */
       
        
        if AppConfig.HomeStruct.Pages[indexPath.item]
            == AppConfig.HomeStruct.Tags.TAG_INBOX{
            
            cell.refreshBadge(count: self.badgeCount)
            
        }
        
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        let count = CGFloat(AppConfig.HomeStruct.Pages.count)
        return CGSize(width: frame.width / count, height: frame.height)
    }

    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}




class MenuCell: BaseCell {
    
    var notification = 0
    var badge: BadgeSwift? = nil
    var activeImage: UIImage?
    var inactiveImage: UIImage?
    
    
    let imageView: UIImageView = {
        let iv = UIImageView()
        //iv.image = UIImage(named: "home")?.withRenderingMode(.alwaysTemplate)
        let color = AppDesignUtils.defaultModeColor(dark:  Colors.primaryColor, light: UIColor.gray.withAlphaComponent(0.5))
        iv.tintColor = color
        iv.contentMode = .scaleAspectFit
        
        return iv
    }()
    
    override var isHighlighted: Bool {
        didSet {
            
            if let icon = inactiveImage{
                imageView.image = isHighlighted ? activeImage : inactiveImage
            }
            
            if AppStyle.Config.uiColor == AppStyle.uiColor.light{
                let active = Colors.primaryColor
                let unactive = UIColor.gray.withAlphaComponent(0.5)
                imageView.tintColor = isHighlighted ? active : unactive
            }else{
                imageView.tintColor = isHighlighted ? .white : Colors.primaryColor
            }
           
        }
    }
    
    override var isSelected: Bool {
        didSet {
            
            if let icon = inactiveImage{
                imageView.image = isSelected ? activeImage : inactiveImage
            }
            
            if AppStyle.Config.uiColor == AppStyle.uiColor.light{
                let active = Colors.primaryColor
                let unactive = UIColor.gray.withAlphaComponent(0.5)
                imageView.tintColor = isSelected ? active : unactive
            }else{
                imageView.tintColor = isSelected ? .white : Colors.primaryColor
            }
            
            
        }
    }
    
    override func setupViews() {
        super.setupViews()
        
        addSubview(imageView)
        addConstraintsWithFormat(format: "H:[v0(28)]", views: imageView)
        addConstraintsWithFormat(format: "V:[v0(28)]", views: imageView)
        
        addConstraint(NSLayoutConstraint(item: imageView, attribute: .centerX, relatedBy: .equal, toItem: self, attribute: .centerX, multiplier: 1, constant: 0))
        addConstraint(NSLayoutConstraint(item: imageView, attribute: .centerY, relatedBy: .equal, toItem: self, attribute: .centerY, multiplier: 1, constant: 5))
        
        if  self.badge == nil {
            self.badge = setupBadge()
            self.badge?.isHidden = true
        }
        
        
    }
    
    
    func refreshBadge(count: Int) {
        self.notification = count
        if let badge = self.badge {
            if notification == 0 {
                badge.isHidden = true
            }else{
                badge.text = "\(notification)"
                badge.isHidden = false
                
            }
        }
    }
    
    
    func setupBadge() -> BadgeSwift {
        
        let badge = BadgeSwift()
        self.addSubview(badge)
        
        // Text
        badge.text = "0"
        
        
        // Insets
        badge.insets = CGSize(width: 4, height: 4)
        
        // Font
        badge.font = UIFont.preferredFont(forTextStyle: UIFont.TextStyle.body)
        badge.font = badge.font.withSize(10)
        
        // Text color
        badge.textColor = Colors.primaryColor
        
        // Badge color
        badge.badgeColor = UIColor.white
        
        // No shadow
        badge.shadowOpacityBadge = 0
        
        badge.borderWidth = 2
        badge.borderColor = Colors.primaryColor
        
        positionBadge(badge)
        
        return badge
    }
    
    private func positionBadge(_ badge: UIView) {
        badge.translatesAutoresizingMaskIntoConstraints = false
        var constraints = [NSLayoutConstraint]()
        
        constraints.append(NSLayoutConstraint(
            item: badge,
            attribute: NSLayoutConstraint.Attribute.right,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self,
            attribute: NSLayoutConstraint.Attribute.right,
            multiplier: 1, constant: -20)
        )
        
        constraints.append(NSLayoutConstraint(
            item: badge,
            attribute: NSLayoutConstraint.Attribute.top,
            relatedBy: NSLayoutConstraint.Relation.equal,
            toItem: self,
            attribute: NSLayoutConstraint.Attribute.top,
            multiplier: 1, constant: 0)
        )
        
        self.addConstraints(constraints)
    }
    
}

