//
//  GalleryViewController.swift
//  NearbyStores
//
//  Created by Amine on 10/22/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit


class GalleryViewController: MyUIViewController {
    
    @IBOutlet weak var mainContainer: UIView!
    @IBOutlet weak var navigationBar: UINavigationBar!
    @IBOutlet weak var navigationBarItem: UINavigationItem!
    
    
    var viewManager: LoaderViewManager =  LoaderViewManager()
    
    
    
    var int_id: Int? = nil
    var type: String? = nil
    
    //request
    var __req_page: Int = 1
    var __req_limit: Int = 30
    
    
    
    func setupNavBarButtons() {
        
        let icon = AppDesignUtils.defaultModeColor(dark: .white, light: Colors.primaryColor)
        
        //arrow back icon
        var arrowImage: UIImage? = nil
        if Utils.isRTL(){
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowForward), size: CGSize(width: 30, height: 30), textColor: icon)
        }else{
            arrowImage = UIImage.init(icon: .ionicons(.iosArrowBack), size: CGSize(width: 30, height: 30), textColor: icon)
        }
        
        
        let customBarButtonItem = UIBarButtonItem(image: arrowImage!, style: .plain, target: self, action: #selector(onBackHandler))
        customBarButtonItem.setIcon(icon: .ionicons(.iosArrowBack), iconSize: 25, color: Colors.white)
      
        navigationBarItem.leftBarButtonItems = []
        navigationBarItem.rightBarButtonItems = []
        navigationBarItem.leftBarButtonItems?.append(customBarButtonItem)
        
    }
    
    let topBarTitle: EdgeLabel = {
        
        let titleLabel = EdgeLabel()
        
        titleLabel.text = ""
        titleLabel.textColor = UIColor.white
        titleLabel.font = UIFont.systemFont(ofSize: 20)
        
        return titleLabel
        
    }()
    
    func setupNavBarTitles() {
        
        
        let rect = CGRect(x: 0, y: 0, width: view.frame.width - 32, height: view.frame.height)
        topBarTitle.frame = rect
        topBarTitle.textColor = UIColor.white
        topBarTitle.font = UIFont(name: AppConfig.Design.Fonts.regular, size: 17)
        topBarTitle.leftTextInset = 5
        
        topBarTitle.text = "Gallery".localized
        
        navigationBarItem.titleView = topBarTitle
        
    }
    
    
    @objc func onBackHandler()  {
        self.dismiss(animated: true)
    }
    
    
    override func viewDidLoad() {
        
        
        self.navigationBar.isTranslucent = false
        self.navigationBar.setBackgroundImage(UIImage(), for: UIBarMetrics.default)
        self.navigationBar.shadowImage = UIImage()
        self.navigationBar.tintColor = .white
        
        
        setupNavBarTitles()
        //setup views
        setupNavBarButtons()
        
        
        
        if let id = self.int_id, let type = self.type{
            
            let galleryView = StoreGalleryListView()
            mainContainer.addSubview(galleryView)
            galleryView.setPosition(parent: mainContainer)
            
            galleryView.module_id = id
            galleryView.module_name = type
            galleryView.short_mode = false
            galleryView.vc = self
            
            galleryView.loadGallery(module_id: id, module: type)
            
            
        }
        
        
        
    }
    
}
