//
//  TransactionCell.swift
//  Dealfly
//
//  Created by Amine maagoul on 16/8/2023.
//  Copyright © 2023 Amine. All rights reserved.
//

import Foundation
import UIKit

class TransactionCell: UICollectionViewCell {
    
    @IBOutlet weak var date: UILabel!
    @IBOutlet weak var transactionId: UILabel!
    @IBOutlet weak var amount: UILabel!
    @IBOutlet weak var operation: UILabel!
    
    
    func setupSettings() {
      
        self.date.initDefaultFont(size: 13)
        self.transactionId.initDefaultFont(size: 13)
        self.operation.initDefaultFont(size: 16)
        self.amount.initBolodFont(size: 16)
        
        self.date.textColor = .gray
        self.transactionId.textColor = .gray
        
    }
    
    func setup(object: WTransaction) {
        
        self.amount.text = object.amount
        self.transactionId.text = object.no
        self.date.text = object.date
        self.operation.text = object.operation
        
        
        var note: String = "";

        if(object.note != "" && object.note != "--" && object.note != "null"){
            note = " (\(object.note))";
        }else{
            note = "";
        }

        
        if(object.operation == "receive"){
            self.operation.text = "Received".localized+note
            self.amount.text = "+\(object.amount)"
            self.amount.textColor = Colors.green
        }else if(object.operation == "send"){
            
            self.operation.text = "Sent".localized+note
            self.amount.text = "-\(object.amount)"
            self.amount.textColor = .red
        }else if(object.operation == "top-up"){
            
            self.operation.text = "You added balance (Top-up)"
            self.amount.text = "+\(object.amount)"
            self.amount.textColor = Colors.green
        
        }else{
            
            self.operation.text = object.operation+note
            self.amount.text = "+\(object.amount)"
            self.amount.textColor = Colors.gray
            
         }
        
    }
}
