//
//  Colors.swift
//  NearbyStores
//
//  Created by Amine on 5/22/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit

struct Colors {

    static let white: UIColor =  Utils.hexStringToUIColor(hex: "#FFFFFF")
    static let white_50: UIColor =  Utils.hexStringToUIColor(hex: "#80FFFFFF")
    static let gray: UIColor =  Utils.hexStringToUIColor(hex: "#90A4AE")
    static let black: UIColor =  Utils.hexStringToUIColor(hex: "#000000")
    static let highlightedGray: UIColor =  Utils.hexStringToUIColor(hex: "#eeeeee")
    static let lightGreen: UIColor =  Utils.hexStringToUIColor(hex: "#8BC34A")
    static let green: UIColor =  Utils.hexStringToUIColor(hex: "#157f1f")

    
    
    static let black_30: UIColor =  Colors.black.withAlphaComponent(CGFloat(0.3))
    static let black_50: UIColor =  Colors.black.withAlphaComponent(CGFloat(0.5))
    static let black_70: UIColor =  Colors.black.withAlphaComponent(CGFloat(0.7))
    
    
    //load from config file
    static let primaryColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.primaryColor)
    
    static let primaryColorTransparency_50: UIColor = Colors.primaryColor.withAlphaComponent(CGFloat(0.5))
    
    static let accentColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.accentColor)
    static let darkColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.darkColor)
    static let darkIconColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.darkIconColor)
    static let featuredTagColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.featuredTagColor)
    static let promoTagColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.promoTagColor)
    static let upComingColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.upComingColor)
    static let dealColor: UIColor =  Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.dealColor)
    static var iphoneDisplayMode: UIColor = UIColor(named: "iphone-display-mode") ?? .black
    
    
    static let bg_gray_100: UIColor =  Utils.hexStringToUIColor(hex: "#EEEEEE")
    static let bg_gray_110: UIColor =  Utils.hexStringToUIColor(hex: "#dfdfdf")
    
    static let color1: UIColor =  Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.first_color)
    static let color2: UIColor =  Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.second_color)
    
    
    static var whiteGrey: UIColor =  UIColor.white
    
    
    static let blackColor: UIColor = Utils.hexStringToUIColor(hex: AppConfig.Design.Colors.blackColor)
    static let bg_gray: UIColor =  Utils.hexStringToUIColor(hex: "#EEEEEE")
    static let lightGrey: UIColor =  Utils.hexStringToUIColor(hex: "#EEEEEE")
    static let blackDarkModeBackgound: UIColor =  Utils.hexStringToUIColor(hex: "#121212")
    static let lightBlack: UIColor =  Utils.hexStringToUIColor(hex: "#050000")
    
    
    enum Appearance {
        
        static var primaryColor: UIColor = Colors.primaryColor
        static var accentColor: UIColor = Colors.accentColor
        static var darkColor: UIColor = Colors.darkColor
        static var blackColor: UIColor = Colors.blackColor
        
        
        
        static var background: UIColor =  Colors.lightGrey
        static var white: UIColor =  UIColor.white
        static var black: UIColor =  UIColor.black
        static var scondary_color: UIColor =  UIColor.black.withAlphaComponent(0.7)
        static var whiteGrey: UIColor =  UIColor.white
        
        static var lightGreyColor = Utils.hexStringToUIColor(hex: "#A39C99")
        static var textColor: UIColor = UIColor(named: "text-color") ?? .black
        static var labelTextColor: UIColor = UIColor(named: "label-text-color") ?? .black
        static var buttonTintColor: UIColor = UIColor(named: "button-tint-color") ?? .black
        static var buttonBackgroundColor: UIColor = UIColor(named: "button-background-color") ?? .black
        static var backgroundColor: UIColor = UIColor(named: "background-color") ?? .black
        static var iphoneDisplayMode: UIColor = UIColor(named: "iphone-display-mode") ?? .black
        static var primaryRedColor: UIColor = Utils.hexStringToUIColor(hex: "#E43A35")
                
    }
    
}
