//
//  OfferCardCell.swift
//  NearbyCategories
//
//  Created by Amine  on 8/11/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import UIKit
import Cosmos
import SwiftIcons
import Kingfisher

class CategoryCardCell: UICollectionViewCell {

    
    //contraints
    @IBOutlet weak var imageConstraintHeight: NSLayoutConstraint!
    @IBOutlet weak var infoConstraintHeight: NSLayoutConstraint!
    
    //view
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var name: UILabel!
  
    @IBOutlet weak var imageContainer: UIView!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
        
    
        
    }
    
    func makeAsDefault() {
        
        self.imageContainer.isSkeletonable = false
        self.name.isSkeletonable = false
        
        self.imageContainer.hideSkeleton()
        self.name.hideSkeleton()
        
    }
    
    func makeAsLoader() {
        
        self.imageContainer.isSkeletonable = true
        self.name.isSkeletonable = true
       
        self.imageContainer.showAnimatedGradientSkeleton()
        self.name.showAnimatedGradientSkeleton()
        
    }
    
    func setting(style: CardHorizontalStyle?){
        
        
        self.imageConstraintHeight.constant = CGFloat(style!.height!-40-Categories_HCards.header_size)
        //self.infoConstraintHeight.constant = CGFloat(35)
        
        self.image.contentMode = .scaleAspectFit
        
        self.image.addRadius()
        self.imageContainer.addShadowView()
        self.imageContainer.backgroundColor = .white
        
        self.name.initDefaultFont(size: 14)
        self.name.textAlignment = .center
       
        
        //test icons
        if let _style = style, let width = _style.width{
            let size = Double(width)/2
            
            let iconTest = UIImage.init(icon: .linearIcons(.coffeeCup), size: CGSize(width: size, height: size), textColor: .white)
            self.image.image = iconTest
            self.image.contentMode = .center
            
        }
        
        
    }
    
    
    func setup(object: Category?) {
        
        if let object = object {
            
            self.makeAsDefault()
            
            self.name.text = object.nameCat
            
            Utils.printDebug("\(object)")
          
            if let image = object.icon, image.id != "" {
                
                let url = URL(string: image.url500_500)
            
                self.image.contentMode = .scaleAspectFit
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2)) ])
                
            }else if let image = object.images, image.id != ""  {
                
                let url = URL(string: image.url500_500)
                
                self.image.contentMode = .scaleAspectFill
                self.image.kf.indicatorType = .activity
                self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
                
            }else{
                if let img = UIImage(named: "default_store_image") {
                    self.image.image = img
                    self.image.contentMode = .scaleAspectFit
                }
            }
            
        }else{
            
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
                self.image.contentMode = .scaleAspectFit
            }
            
            self.makeAsLoader()
        }
        
        
    }

}
