//
//  Category.swift
//  NearbyStores
//
//  Created by Amine on 5/20/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import RealmSwift

class Category: Object{
    
    
    @objc dynamic var numCat: Int = 0
    @objc dynamic var type: Int = 0
    @objc dynamic var nameCat: String = ""
    @objc dynamic var parentCategory: Int = 0
    @objc dynamic var icon: Images? = nil
    @objc dynamic var menu: Bool = false
    @objc dynamic var nbr_stores: Int = 0
    @objc dynamic var images: Images? = nil
    @objc dynamic var color: String? = nil
    @objc dynamic var _order: Int = 0
    @objc dynamic var count: Int = 0
    
    override static func primaryKey() -> String? {
        return "numCat"
    }
    

}

extension Category{
    
    func save() {
        
        if self.numCat > 0 {
            let category = self
            
            let realm = try! Realm()
            realm.beginWrite()
            realm.add(category,update: .all)
            try! realm.commitWrite()
            
        }
    }
    
    static func findById(id: Int) -> Category? {
        
        let realm = try! Realm()
        
        if let category = realm.objects(Category.self).filter("numCat == \(id)").first {
            return category
        }
        
        return nil
    }
    
    static func getTopSubCategories() -> [Category] {
        
        let realm = try! Realm()
        
        let sortProperties = [SortDescriptor(keyPath: "count", ascending: false), SortDescriptor(keyPath: "_order", ascending: true)]
        let realmResults = realm.objects(Category.self).filter("parentCategory > 0").sorted(by: sortProperties)
        
        return Array(realmResults)
    }
    
    static func getAll() -> [Category] {
        
        let realm = try! Realm()
        
        let sortProperties = [SortDescriptor(keyPath: "_order", ascending: true), SortDescriptor(keyPath: "count", ascending: false)]
        let realmResults = realm.objects(Category.self).sorted(by: sortProperties)
        
        return Array(realmResults)
    }
    
    static func findByParent(parent_id: Int) -> [Category] {
        
        let realm = try! Realm()
        
        let realmResults = realm.objects(Category.self).filter("parentCategory == \(parent_id)").sorted(byKeyPath: "_order",ascending: true)
        
        return Array(realmResults)
    }
    
    static func findParents() -> [Category] {
        
        let realm = try! Realm()
        
        let realmResults = realm.objects(Category.self).filter("parentCategory == 0").sorted(byKeyPath: "_order",ascending: true)
        
        return Array(realmResults)
    }
    
    static  func removeAllFromRealm(){
        
        let realm = try! Realm()
        realm.beginWrite()
        realm.deleteAll()
        try! realm.commitWrite()
        
    }
}

extension Array where Element:Category {
    
    func saveAll(){
        
        let categories: [Category] = self
        
        if categories.count > 0 {
            
            let realm = try! Realm()
            
            realm.beginWrite()
            realm.add(categories,update: .all)
            try! realm.commitWrite()
            
        }
        
    }
    
    
   
        
}
